/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.io.PlaceholderFile;
import adams.data.image.BufferedImageContainer;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.output.AbstractImageWriter;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import ar.com.hjg.pngj.IImageLine;
import ar.com.hjg.pngj.ImageLineByte;
import ar.com.hjg.pngj.ImageLineInt;
import ar.com.hjg.pngj.PngReader;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class PNGImageReader
extends AbstractImageReader<BufferedImageContainer> {
    private static final long serialVersionUID = -4360936418761836176L;
    protected ColorProvider m_ColorProvider;
    protected transient int m_LastColor;
    protected transient Map<Integer, Integer> m_Colors;

    public String globalInfo() {
        return "Reads images in PNG format.\nIn case of images with a palette (= indexed), the color provider is used for generating the colors (the palette itself cannot be read with this reader, unfortunately).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color-provider", "colorProvider", (Object)new DefaultColorProvider());
    }

    public void setColorProvider(ColorProvider value) {
        this.m_ColorProvider = value;
        this.reset();
    }

    public ColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public String colorProviderTipText() {
        return "The color provider to use for images with a palette.";
    }

    public String getFormatDescription() {
        return "PNG";
    }

    public String[] getFormatExtensions() {
        return new String[]{"png"};
    }

    public AbstractImageWriter getCorrespondingWriter() {
        return null;
    }

    protected int paletteToColor(int index) {
        if (!this.m_Colors.containsKey(index)) {
            for (int i = this.m_LastColor + 1; i <= index; ++i) {
                this.m_Colors.put(i, this.m_ColorProvider.next().getRGB());
            }
            this.m_LastColor = index;
        }
        return this.m_Colors.get(index);
    }

    protected BufferedImageContainer doRead(PlaceholderFile file) {
        BufferedImageContainer result = new BufferedImageContainer();
        try {
            int channels;
            this.m_ColorProvider.resetColors();
            this.m_LastColor = -1;
            this.m_Colors = new HashMap<Integer, Integer>();
            PngReader reader = new PngReader(file.getAbsoluteFile());
            if (this.isLoggingEnabled()) {
                this.getLogger().info(reader.imgInfo.toString());
            }
            BufferedImage image = (channels = reader.imgInfo.channels) == 4 ? new BufferedImage(reader.imgInfo.cols, reader.imgInfo.rows, 2) : (channels == 3 ? new BufferedImage(reader.imgInfo.cols, reader.imgInfo.rows, 1) : (channels == 2 ? new BufferedImage(reader.imgInfo.cols, reader.imgInfo.rows, 2) : (reader.imgInfo.indexed ? new BufferedImage(reader.imgInfo.cols, reader.imgInfo.rows, 13) : new BufferedImage(reader.imgInfo.cols, reader.imgInfo.rows, 1))));
            int[] pixels = new int[reader.imgInfo.cols * reader.imgInfo.rows];
            for (int n = 0; n < reader.imgInfo.rows; ++n) {
                int color;
                int i;
                IImageLine line = reader.readRow();
                if (line instanceof ImageLineByte) {
                    ImageLineByte lineByte = (ImageLineByte)reader.readRow(n);
                    for (i = 0; i < reader.imgInfo.cols; ++i) {
                        color = channels == 4 ? lineByte.getElem(i * channels + 3) << 24 | lineByte.getElem(i * channels) << 16 | lineByte.getElem(i * channels + 1) << 8 | lineByte.getElem(i * channels + 2) : (channels == 3 ? lineByte.getElem(i * channels) << 16 | lineByte.getElem(i * channels + 1) << 8 | lineByte.getElem(i * channels + 2) : (channels == 2 ? lineByte.getElem(i * channels + 1) << 24 | lineByte.getElem(i * channels) << 16 | lineByte.getElem(i * channels) << 8 | lineByte.getElem(i * channels) : (reader.imgInfo.indexed && channels == 1 ? this.paletteToColor(lineByte.getElem(i)) : lineByte.getElem(i) << 16 | lineByte.getElem(i) << 8 | lineByte.getElem(i))));
                        pixels[i + n * reader.imgInfo.cols] = color;
                    }
                    continue;
                }
                ImageLineInt lineInt = (ImageLineInt)reader.readRow(n);
                for (i = 0; i < reader.imgInfo.cols; ++i) {
                    color = channels == 4 ? lineInt.getElem(i * channels + 3) << 24 | lineInt.getElem(i * channels) << 16 | lineInt.getElem(i * channels + 1) << 8 | lineInt.getElem(i * channels + 2) : (channels == 3 ? lineInt.getElem(i * channels) << 16 | lineInt.getElem(i * channels + 1) << 8 | lineInt.getElem(i * channels + 2) : (channels == 2 ? lineInt.getElem(i * channels + 1) << 24 | lineInt.getElem(i * channels) << 16 | lineInt.getElem(i * channels) << 8 | lineInt.getElem(i * channels) : (reader.imgInfo.indexed && channels == 1 ? this.paletteToColor(lineInt.getElem(i)) : lineInt.getElem(i) << 16 | lineInt.getElem(i) << 8 | lineInt.getElem(i))));
                    pixels[i + n * reader.imgInfo.cols] = color;
                }
            }
            image.setRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
            result.setImage((Object)image);
        }
        catch (Exception e) {
            result = null;
            this.getLogger().log(Level.SEVERE, "Failed to read PNG: " + file, (Throwable)e);
        }
        return result;
    }
}

