/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import ar.com.hjg.pngj.IImageLine;
import ar.com.hjg.pngj.ImageLineByte;
import ar.com.hjg.pngj.ImageLineInt;
import ar.com.hjg.pngj.PngReader;
import java.io.InputStream;
import java.util.logging.Level;

public class PNGSpreadSheetReader
extends AbstractSpreadSheetReader {
    private static final long serialVersionUID = 1662813915131999182L;

    public String globalInfo() {
        return "Reads PNGs as spreadsheet, e.g., for reading indexed PNGs.";
    }

    public String getFormatDescription() {
        return "PNG reader";
    }

    public String[] getFormatExtensions() {
        return new String[]{"png"};
    }

    public SpreadSheetWriter getCorrespondingWriter() {
        return null;
    }

    protected AbstractSpreadSheetReader.InputType getInputType() {
        return AbstractSpreadSheetReader.InputType.STREAM;
    }

    protected SpreadSheet doRead(InputStream in) {
        DefaultSpreadSheet result;
        try {
            int i;
            PngReader reader = new PngReader(in);
            if (this.isLoggingEnabled()) {
                this.getLogger().info(reader.imgInfo.toString());
            }
            result = new DefaultSpreadSheet();
            int channels = reader.imgInfo.channels;
            HeaderRow row = result.getHeaderRow();
            for (i = 0; i < reader.imgInfo.cols; ++i) {
                row.addCell("" + i).setContentAsString("" + (i + 1));
            }
            for (int n = 0; n < reader.imgInfo.rows; ++n) {
                int color;
                row = result.addRow();
                IImageLine line = reader.readRow();
                if (line instanceof ImageLineByte) {
                    ImageLineByte lineByte = (ImageLineByte)reader.readRow(n);
                    for (i = 0; i < reader.imgInfo.cols; ++i) {
                        color = channels == 4 ? lineByte.getElem(i * channels + 3) << 24 | lineByte.getElem(i * channels) << 16 | lineByte.getElem(i * channels + 1) << 8 | lineByte.getElem(i * channels + 2) : (channels == 3 ? lineByte.getElem(i * channels) << 16 | lineByte.getElem(i * channels + 1) << 8 | lineByte.getElem(i * channels + 2) : (channels == 2 ? lineByte.getElem(i * channels + 1) << 24 | lineByte.getElem(i * channels) << 16 | lineByte.getElem(i * channels) << 8 | lineByte.getElem(i * channels) : lineByte.getElem(i) << 16 | lineByte.getElem(i) << 8 | lineByte.getElem(i)));
                        row.addCell("" + i).setContent(Integer.valueOf(color));
                    }
                    continue;
                }
                ImageLineInt lineInt = (ImageLineInt)reader.readRow(n);
                for (i = 0; i < reader.imgInfo.cols; ++i) {
                    color = channels == 4 ? lineInt.getElem(i * channels + 3) << 24 | lineInt.getElem(i * channels) << 16 | lineInt.getElem(i * channels + 1) << 8 | lineInt.getElem(i * channels + 2) : (channels == 3 ? lineInt.getElem(i * channels) << 16 | lineInt.getElem(i * channels + 1) << 8 | lineInt.getElem(i * channels + 2) : (channels == 2 ? lineInt.getElem(i * channels + 1) << 24 | lineInt.getElem(i * channels) << 16 | lineInt.getElem(i * channels) << 8 | lineInt.getElem(i * channels) : lineInt.getElem(i) << 16 | lineInt.getElem(i) << 8 | lineInt.getElem(i)));
                    row.addCell("" + i).setContent(Integer.valueOf(color));
                }
            }
        }
        catch (Exception e) {
            result = null;
            this.getLogger().log(Level.SEVERE, "Failed to read PNG!", (Throwable)e);
        }
        return result;
    }
}

