/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.data.image.BufferedImageContainer;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.ApacheCommonsImageReader;
import adams.data.io.output.AbstractImageWriter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.Imaging;

public class ApacheCommonsImageWriter
extends AbstractImageWriter<BufferedImageContainer> {
    private static final long serialVersionUID = 6385191315392140321L;

    public String globalInfo() {
        return "Apache Commons Imaging writer for: " + Utils.flatten((Object[])this.getFormatExtensions(), (String)", ");
    }

    public String getFormatDescription() {
        return "Apache Commons Imaging writer";
    }

    public String[] getFormatExtensions() {
        return new String[]{"bmp", "dcx", "gif", "hdr", "icns", "ico", "jpg", "pcx", "png", "pnm", "psd", "tif", "tiff", "wbmp", "xbm", "xpm"};
    }

    public AbstractImageReader getCorrespondingReader() {
        return new ApacheCommonsImageReader();
    }

    protected String doWrite(PlaceholderFile file, BufferedImageContainer cont) {
        ImageFormats format;
        String ext;
        String result = null;
        switch (ext = FileUtils.getExtension((File)file)) {
            case "bmp": {
                format = ImageFormats.BMP;
                break;
            }
            case "gif": {
                format = ImageFormats.GIF;
                break;
            }
            case "hdr": {
                format = ImageFormats.RGBE;
                break;
            }
            case "ico": {
                format = ImageFormats.ICO;
                break;
            }
            case "icns": {
                format = ImageFormats.ICNS;
                break;
            }
            case "jpg": 
            case "jpeg": {
                format = ImageFormats.JPEG;
                break;
            }
            case "pcx": {
                format = ImageFormats.PCX;
                break;
            }
            case "png": {
                format = ImageFormats.PNG;
                break;
            }
            case "pnm": {
                format = ImageFormats.PNM;
                break;
            }
            case "psd": {
                format = ImageFormats.PSD;
                break;
            }
            case "tif": 
            case "tiff": {
                format = ImageFormats.TIFF;
                break;
            }
            case "wbmp": {
                format = ImageFormats.WBMP;
                break;
            }
            case "xbm": {
                format = ImageFormats.XBM;
                break;
            }
            case "xpm": {
                format = ImageFormats.XPM;
                break;
            }
            default: {
                format = null;
            }
        }
        if (format == null) {
            result = "Unhandled file extension: " + ext;
        }
        if (result == null) {
            try {
                Imaging.writeImage((BufferedImage)cont.toBufferedImage(), (File)file.getAbsoluteFile(), (ImageFormat)format, new HashMap());
            }
            catch (Exception e) {
                result = LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to write image to: " + file), (Throwable)e);
            }
        }
        return result;
    }
}

