/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.base.BaseObject;
import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.data.image.BufferedImageHelper;
import adams.data.io.input.AbstractImageSegmentationAnnotationReader;
import adams.data.io.input.BlueChannelImageSegmentationReader;
import adams.data.io.output.AbstractImageSegmentationAnnotationWriter;
import adams.flow.container.ImageSegmentationContainer;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import java.util.Map;

public class BlueChannelImageSegmentationWriter
extends AbstractImageSegmentationAnnotationWriter {
    private static final long serialVersionUID = 3566330074754565825L;
    protected BaseString[] m_LayerNames;

    public String globalInfo() {
        return "The layers get stored in the blue channel, with 0 being the background.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("layer-name", "layerNames", (Object)new BaseString[0]);
    }

    public void setLayerNames(BaseString[] value) {
        this.m_LayerNames = value;
        this.reset();
    }

    public BaseString[] getLayerNames() {
        return this.m_LayerNames;
    }

    public String layerNamesTipText() {
        return "The names to of the layers to output; outputs all if none specified.";
    }

    @Override
    public AbstractImageSegmentationAnnotationReader getCorrespondingReader() {
        return new BlueChannelImageSegmentationReader();
    }

    public String getFormatDescription() {
        return new BlueChannelImageSegmentationReader().getFormatDescription();
    }

    public String[] getFormatExtensions() {
        return new BlueChannelImageSegmentationReader().getFormatExtensions();
    }

    public String getDefaultFormatExtension() {
        return new BlueChannelImageSegmentationReader().getDefaultFormatExtension();
    }

    @Override
    protected String check(PlaceholderFile file, ImageSegmentationContainer annotations) {
        Map layers;
        String result = super.check(file, annotations);
        if (result == null && ((layers = (Map)annotations.getValue("layers")) == null || layers.size() == 0)) {
            result = "No layers in container!";
        }
        return result;
    }

    @Override
    protected String doWrite(PlaceholderFile file, ImageSegmentationContainer annotations) {
        Object[] layerNames;
        BufferedImage baseImage = (BufferedImage)annotations.getValue("base");
        Map layers = (Map)annotations.getValue("layers");
        if (this.m_LayerNames.length == 0) {
            layerNames = layers.keySet().toArray(new String[0]);
            Arrays.sort(layerNames);
        } else {
            layerNames = BaseObject.toStringArray((BaseObject[])this.m_LayerNames);
        }
        int[] combPixels = new int[baseImage.getWidth() * baseImage.getHeight()];
        for (int i = 0; i < layerNames.length; ++i) {
            if (!layers.containsKey(layerNames[i])) continue;
            int[] currPixels = BufferedImageHelper.getPixels((BufferedImage)((BufferedImage)layers.get(layerNames[i])));
            for (int n = 0; n < currPixels.length; ++n) {
                if ((currPixels[n] & 0xFFFFFF) <= 0) continue;
                combPixels[n] = 0xFF000000 | i + 1;
            }
        }
        BufferedImage combImage = new BufferedImage(baseImage.getWidth(), baseImage.getHeight(), 1);
        combImage.setRGB(0, 0, combImage.getWidth(), combImage.getHeight(), combPixels, 0, combImage.getWidth());
        return BufferedImageHelper.write((BufferedImage)combImage, (File)file);
    }
}

