/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.io.input.AbstractImageSegmentationAnnotationReader;
import adams.data.io.input.IndividualImageSegmentationLayerReader;
import adams.data.io.output.AbstractImageSegmentationAnnotationWriter;
import adams.data.io.output.ApacheCommonsImageWriter;
import adams.flow.container.ImageSegmentationContainer;
import gnu.trove.set.hash.TIntHashSet;
import java.awt.image.BufferedImage;
import java.util.Map;

public class IndividualImageSegmentationLayerWriter
extends AbstractImageSegmentationAnnotationWriter {
    private static final long serialVersionUID = 8630734382383387883L;
    protected boolean m_SkipBaseImage;
    protected boolean m_SkipEmptyLayers;

    public String globalInfo() {
        return "Uses a JPG as base image and indexed PNG files for the individual layers (0 = background, 1 = annotation).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("skip-base-image", "skipBaseImage", (Object)false);
        this.m_OptionManager.add("skip-empty-layers", "skipEmptyLayers", (Object)false);
    }

    public String getFormatDescription() {
        return "Individual image segmentation layers";
    }

    public String[] getFormatExtensions() {
        return new String[]{"jpg"};
    }

    public String getDefaultFormatExtension() {
        return this.getFormatExtensions()[0];
    }

    @Override
    public AbstractImageSegmentationAnnotationReader getCorrespondingReader() {
        return new IndividualImageSegmentationLayerReader();
    }

    public void setSkipBaseImage(boolean value) {
        this.m_SkipBaseImage = value;
        this.reset();
    }

    public boolean getSkipBaseImage() {
        return this.m_SkipBaseImage;
    }

    public String skipBaseImageTipText() {
        return "If enabled, the base image is not written to disk (eg when updating only the layers).";
    }

    public void setSkipEmptyLayers(boolean value) {
        this.m_SkipEmptyLayers = value;
        this.reset();
    }

    public boolean getSkipEmptyLayers() {
        return this.m_SkipEmptyLayers;
    }

    public String skipEmptyLayersTipText() {
        return "If enabled, layers that consist only of background are not included in the output.";
    }

    protected String writeFile(BufferedImage image, PlaceholderFile file) {
        BufferedImageContainer cont = new BufferedImageContainer();
        cont.setImage((Object)image);
        ApacheCommonsImageWriter writer = new ApacheCommonsImageWriter();
        return writer.write(file, (AbstractImageContainer)cont);
    }

    protected int countColors(BufferedImage image) {
        TIntHashSet colors = new TIntHashSet();
        int[] pixels = BufferedImageHelper.getPixels((BufferedImage)image);
        for (int i = 0; i < pixels.length; ++i) {
            colors.add(pixels[i]);
        }
        return colors.size();
    }

    @Override
    protected String doWrite(PlaceholderFile file, ImageSegmentationContainer annotations) {
        String result = null;
        String prefix = FileUtils.replaceExtension((String)file.getAbsolutePath(), (String)"");
        if (!this.m_SkipBaseImage) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Writing base image to: " + file);
            }
            if ((result = this.writeFile((BufferedImage)annotations.getValue("base", BufferedImage.class), file)) != null) {
                result = "Failed to write base image: " + result;
            }
        }
        if (result == null && annotations.hasValue("layers")) {
            Map layers = (Map)annotations.getValue("layers", Map.class);
            for (String label : layers.keySet()) {
                if (this.m_SkipEmptyLayers && this.countColors((BufferedImage)layers.get(label)) == 1) {
                    if (!this.isLoggingEnabled()) continue;
                    this.getLogger().info("Layer '" + label + "' is empty, skipping!");
                    continue;
                }
                PlaceholderFile layerFile = new PlaceholderFile(prefix + "-" + label + ".png");
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Writing layer '" + label + "' to: " + layerFile);
                }
                if ((result = this.writeFile((BufferedImage)layers.get(label), layerFile)) == null) continue;
                result = "Failed to write layer '" + label + "': " + result;
                break;
            }
        }
        if (result != null && this.isLoggingEnabled()) {
            this.getLogger().severe(result);
        }
        return result;
    }
}

