/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.io.FileUtils;
import adams.core.io.PrettyPrintingSupporter;
import adams.data.io.input.ViaAnnotationsReportReader;
import adams.data.io.output.AbstractReportWriter;
import adams.data.json.JsonHelper;
import adams.data.objectfinder.AllFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.awt.Polygon;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public class ViaAnnotationsReportWriter
extends AbstractReportWriter<Report>
implements PrettyPrintingSupporter {
    private static final long serialVersionUID = -7250784020894287952L;
    protected ObjectFinder m_Finder;
    protected String m_LabelKey;
    protected boolean m_PrettyPrinting;

    public String globalInfo() {
        return "Writes polygon annotations in VGG Image Annotator JSON format.\nFor more information, see:\nhttp://www.robots.ox.ac.uk/~vgg/software/via/";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finder", (Object)new AllFinder());
        this.m_OptionManager.add("label-key", "labelKey", (Object)"");
        this.m_OptionManager.add("pretty-printing", "prettyPrinting", (Object)false);
    }

    public void setFinder(ObjectFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public ObjectFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The object finder to use.";
    }

    public void setLabelKey(String value) {
        this.m_LabelKey = value;
        this.reset();
    }

    public String getLabelKey() {
        return this.m_LabelKey;
    }

    public String labelKeyTipText() {
        return "The key in the meta-data containing the label, ignored if empty.";
    }

    public void setPrettyPrinting(boolean value) {
        this.m_PrettyPrinting = value;
        this.reset();
    }

    public boolean getPrettyPrinting() {
        return this.m_PrettyPrinting;
    }

    public String prettyPrintingTipText() {
        return "If enabled, the output is printed in a 'pretty' format.";
    }

    public String getFormatDescription() {
        return new ViaAnnotationsReportReader().getFormatDescription();
    }

    public String[] getFormatExtensions() {
        return new ViaAnnotationsReportReader().getFormatExtensions();
    }

    protected boolean writeData(Report data) {
        JSONObject all = new JSONObject();
        JSONObject jrep = new JSONObject();
        jrep.put((Object)"fileref", (Object)"");
        jrep.put((Object)"size", (Object)0);
        jrep.put((Object)"base64_img_data", (Object)"");
        jrep.put((Object)"file_attributes", (Object)new JSONObject());
        JSONObject jregions = new JSONObject();
        jrep.put((Object)"regions", (Object)jregions);
        String name = this.m_Output.getName();
        if (data.hasValue("Name")) {
            name = data.getStringValue("Name");
        } else if (data.hasValue("Filename")) {
            name = data.getStringValue("Filename");
        }
        jrep.put((Object)"filename", (Object)name);
        all.put((Object)name, (Object)jrep);
        LocatedObjects objs = this.m_Finder.findObjects(data);
        for (int n = 0; n < objs.size(); ++n) {
            JSONArray jpoints;
            LocatedObject obj = (LocatedObject)objs.get(n);
            JSONObject jregion = new JSONObject();
            jregions.put((Object)("" + n), (Object)jregion);
            JSONObject jshape = new JSONObject();
            jregion.put((Object)"shape_attributes", (Object)jshape);
            JSONObject jatts = new JSONObject();
            jregion.put((Object)"region_attributes", (Object)jatts);
            if (!this.m_LabelKey.isEmpty() && obj.getMetaData().get(this.m_LabelKey) != null) {
                jatts.put((Object)"name", obj.getMetaData().get(this.m_LabelKey));
            }
            jshape.put((Object)"name", (Object)"polygon");
            if (obj.hasPolygon()) {
                int i;
                Polygon polygon = obj.getPolygon();
                jpoints = new JSONArray();
                int[] x = polygon.xpoints;
                for (i = 0; i < x.length; ++i) {
                    jpoints.add((Object)x[i]);
                }
                jshape.put((Object)"all_points_x", (Object)jpoints);
                jpoints = new JSONArray();
                int[] y = polygon.ypoints;
                for (i = 0; i < y.length; ++i) {
                    jpoints.add((Object)y[i]);
                }
                jshape.put((Object)"all_points_y", (Object)jpoints);
                continue;
            }
            jpoints = new JSONArray();
            jpoints.add((Object)obj.getX());
            jpoints.add((Object)(obj.getX() + obj.getWidth() - 1));
            jpoints.add((Object)(obj.getX() + obj.getWidth() - 1));
            jpoints.add((Object)obj.getX());
            jshape.put((Object)"all_points_x", (Object)jpoints);
            jpoints = new JSONArray();
            jpoints.add((Object)obj.getY());
            jpoints.add((Object)obj.getY());
            jpoints.add((Object)(obj.getY() + obj.getHeight() - 1));
            jpoints.add((Object)(obj.getY() + obj.getHeight() - 1));
            jshape.put((Object)"all_points_y", (Object)jpoints);
        }
        String content = this.m_PrettyPrinting ? JsonHelper.prettyPrint((String)all.toString()) : all.toString();
        return FileUtils.writeToFile((String)this.m_Output.getAbsolutePath(), (Object)content, (boolean)false);
    }
}

