/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.transformer;

import adams.data.image.BufferedImageContainer;
import adams.data.jai.transformer.AbstractJAITransformer;
import java.awt.Color;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;

public class Rotate
extends AbstractJAITransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected double m_Angle;
    protected int m_OriginX;
    protected int m_OriginY;
    protected InterpolationType m_Interpolation;
    protected Color m_Background;

    public String globalInfo() {
        return "Rotates an image by a defined number of degrees.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("angle", "angle", (Object)0.0, (Number)0.0, (Number)360.0);
        this.m_OptionManager.add("origin-x", "originX", (Object)-2, (Number)-3, null);
        this.m_OptionManager.add("origin-y", "originY", (Object)-2, (Number)-3, null);
        this.m_OptionManager.add("interpolation", "interpolation", (Object)InterpolationType.BILINEAR);
        this.m_OptionManager.add("background", "background", (Object)Color.BLACK);
    }

    public void setAngle(double value) {
        if (this.getOptionManager().isValid("angle", (Number)value)) {
            this.m_Angle = value;
            this.reset();
        }
    }

    public double getAngle() {
        return this.m_Angle;
    }

    public String angleTipText() {
        return "The angle, in degrees, to rotate the image by.";
    }

    public void setOriginX(int value) {
        if (this.getOptionManager().isValid("originX", (Number)value)) {
            this.m_OriginX = value;
            this.reset();
        }
    }

    public int getOriginX() {
        return this.m_OriginX;
    }

    public String originXTipText() {
        return "The X position of the origin; special values: -1 = left, -2 = center, -3 = right.";
    }

    public void setOriginY(int value) {
        if (this.getOptionManager().isValid("originY", (Number)value)) {
            this.m_OriginY = value;
            this.reset();
        }
    }

    public int getOriginY() {
        return this.m_OriginY;
    }

    public String originYTipText() {
        return "The Y position of the origin; special values: -1 = top, -2 = center, -3 = bottom.";
    }

    public void setInterpolation(InterpolationType value) {
        this.m_Interpolation = value;
        this.reset();
    }

    public InterpolationType getInterpolation() {
        return this.m_Interpolation;
    }

    public String interpolationTipText() {
        return "The type of interpolation to perform.";
    }

    public void setBackground(Color value) {
        this.m_Background = value;
        this.reset();
    }

    public Color getBackground() {
        return this.m_Background;
    }

    public String backgroundTipText() {
        return "The color to use for the background of the rotated image.";
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        BufferedImageContainer[] result = new BufferedImageContainer[1];
        ParameterBlockJAI pb = new ParameterBlockJAI("rotate");
        pb.addSource(img.getImage());
        float x = this.m_OriginX == -1 ? 0.0f : (this.m_OriginX == -2 ? (float)(img.getWidth() / 2) : (this.m_OriginX == -3 ? (float)img.getWidth() - 1.0f : (float)this.m_OriginX));
        float y = this.m_OriginY == -1 ? 0.0f : (this.m_OriginY == -2 ? (float)(img.getHeight() / 2) : (this.m_OriginY == -3 ? (float)img.getHeight() - 1.0f : (float)this.m_OriginY));
        pb.setParameter("xOrigin", x);
        pb.setParameter("yOrigin", y);
        pb.setParameter("angle", (float)(this.m_Angle / 360.0 * Math.PI * 2.0));
        switch (this.m_Interpolation) {
            case NONE: {
                break;
            }
            case BILINEAR: {
                pb.setParameter("interpolation", (Object)new InterpolationBilinear());
                break;
            }
            case NEAREST: {
                pb.setParameter("interpolation", (Object)new InterpolationNearest());
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled interpolation type: " + (Object)((Object)this.m_Interpolation));
            }
        }
        pb.setParameter("backgroundValues", (Object)new double[]{this.m_Background.getRed(), this.m_Background.getGreen(), this.m_Background.getBlue()});
        RenderedOp renderedOp = JAI.create((String)"rotate", (ParameterBlock)pb, null);
        result[0] = (BufferedImageContainer)img.getHeader();
        result[0].setImage((Object)renderedOp.getRendering().getAsBufferedImage());
        return result;
    }

    public static enum InterpolationType {
        NONE,
        BILINEAR,
        NEAREST;

    }
}

