/*
 * Decompiled with CFR 0.152.
 */
package adams.data.objectfilter;

import adams.core.option.AbstractOptionHandler;
import adams.data.objectfilter.ObjectFilter;
import adams.flow.core.Actor;
import adams.flow.transformer.locateobjects.LocatedObjects;

public abstract class AbstractObjectFilter
extends AbstractOptionHandler
implements ObjectFilter {
    private static final long serialVersionUID = -5536282098947025494L;
    protected Actor m_FlowContext;

    public void setFlowContext(Actor value) {
        this.m_FlowContext = value;
    }

    public Actor getFlowContext() {
        return this.m_FlowContext;
    }

    protected boolean requiresFlowContext() {
        return false;
    }

    public String getQuickInfo() {
        return null;
    }

    protected String check(LocatedObjects objects) {
        if (this.requiresFlowContext() && this.m_FlowContext == null) {
            return "No flow context provided!";
        }
        if (objects == null) {
            return "No objects provided!";
        }
        return null;
    }

    protected abstract LocatedObjects doFilter(LocatedObjects var1);

    @Override
    public LocatedObjects filter(LocatedObjects objects) {
        String msg = this.check(objects);
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
        return this.doFilter(objects);
    }
}

