/*
 * Decompiled with CFR 0.152.
 */
package adams.data.objectfilter;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.objectfilter.AbstractObjectFilter;
import adams.data.report.DataType;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;

public class AttachMetaData
extends AbstractObjectFilter {
    private static final long serialVersionUID = 5647107073729835067L;
    protected String m_Key;
    protected DataType m_DataType;
    protected String m_Value;

    public String globalInfo() {
        return "Attaches the specified meta-data value.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("key", "key", (Object)"");
        this.m_OptionManager.add("data-type", "dataType", (Object)DataType.STRING);
        this.m_OptionManager.add("value", "value", (Object)"");
    }

    public void setKey(String value) {
        this.m_Key = value;
        this.reset();
    }

    public String getKey() {
        return this.m_Key;
    }

    public String keyTipText() {
        return "The key of the meta-data value to add.";
    }

    public void setDataType(DataType value) {
        this.m_DataType = value;
        this.reset();
    }

    public DataType getDataType() {
        return this.m_DataType;
    }

    public String dataTypeTipText() {
        return "The data type to use for the meta-data.";
    }

    public void setValue(String value) {
        this.m_Value = value;
        this.reset();
    }

    public String getValue() {
        return this.m_Value;
    }

    public String valueTipText() {
        return "The meta-data value to add.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"key", (Object)this.m_Key, (String)"key: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"dataType", (Object)this.m_DataType, (String)", type: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"value", (Object)this.m_Value, (String)", value: ");
        return result;
    }

    @Override
    protected LocatedObjects doFilter(LocatedObjects objects) {
        Object val;
        LocatedObjects result = new LocatedObjects();
        switch (this.m_DataType) {
            case BOOLEAN: {
                val = Boolean.parseBoolean(this.m_Value);
                break;
            }
            case NUMERIC: {
                val = Double.parseDouble(this.m_Value);
                break;
            }
            default: {
                val = this.m_Value;
            }
        }
        for (LocatedObject object : objects) {
            object = object.getClone();
            object.getMetaData().put(this.m_Key, val);
            result.add(object);
        }
        return result;
    }
}

