/*
 * Decompiled with CFR 0.152.
 */
package adams.data.objectfilter;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseString;
import adams.core.option.OptionHandler;
import adams.data.objectfilter.AbstractObjectFilter;
import adams.data.objectfinder.AllFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.data.objectoverlap.AreaRatio;
import adams.data.objectoverlap.ObjectOverlap;
import adams.data.report.Report;
import adams.flow.control.StorageName;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AttachOverlappingMetaData
extends AbstractObjectFilter {
    private static final long serialVersionUID = 5647107073729835067L;
    protected StorageName m_StorageName;
    protected ObjectFinder m_Finder;
    protected ObjectOverlap m_OverlapDetection;
    protected BaseString[] m_MetaDataKeys;

    public String globalInfo() {
        return "Attaches meta-data from the stored report";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName());
        this.m_OptionManager.add("finder", "finder", (Object)new AllFinder());
        this.m_OptionManager.add("overlap-detection", "overlapDetection", (Object)new AreaRatio());
        this.m_OptionManager.add("meta-data-key", "metaDataKeys", (Object)new BaseString[0]);
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the report in storage to obtain the meta-data from.";
    }

    public void setFinder(ObjectFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public ObjectFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The object finder for locating the objects of interest in the storage report.";
    }

    public void setOverlapDetection(ObjectOverlap value) {
        this.m_OverlapDetection = value;
        this.reset();
    }

    public ObjectOverlap getOverlapDetection() {
        return this.m_OverlapDetection;
    }

    public String overlapDetectionTipText() {
        return "The algorithm to use for determining the overlapping objects.";
    }

    public void setMetaDataKeys(BaseString[] value) {
        this.m_MetaDataKeys = value;
        this.reset();
    }

    public BaseString[] getMetaDataKeys() {
        return this.m_MetaDataKeys;
    }

    public String metaDataKeysTipText() {
        return "The keys of the meta-data values to attach.";
    }

    @Override
    protected boolean requiresFlowContext() {
        return true;
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"storageName", (Object)this.m_StorageName, (String)"storage: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"finder", (Object)this.m_Finder, (String)", finder: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"overlapDetection", (Object)this.m_OverlapDetection, (String)", overlap: ");
        return result;
    }

    @Override
    protected String check(LocatedObjects objects) {
        String result = super.check(objects);
        if (result == null && !this.m_FlowContext.getStorageHandler().getStorage().has(this.m_StorageName)) {
            result = "Report is not available from storage: " + this.m_StorageName;
        }
        return result;
    }

    @Override
    protected LocatedObjects doFilter(LocatedObjects objects) {
        Report report = (Report)this.m_FlowContext.getStorageHandler().getStorage().get(this.m_StorageName);
        LocatedObjects others = this.m_Finder.findObjects(report);
        Map<LocatedObject, Set<LocatedObject>> matches = this.m_OverlapDetection.matches(objects, others);
        for (LocatedObject object : matches.keySet()) {
            Iterator<LocatedObject> iter;
            int index = objects.indexOf(object);
            if (index == -1) {
                this.getLogger().warning("Failed to locate object: " + object);
                continue;
            }
            Set<LocatedObject> overlaps = matches.get(object);
            if (overlaps.size() > 1) {
                this.getLogger().warning("More than one overlap for: " + object);
            }
            if (!(iter = overlaps.iterator()).hasNext()) continue;
            LocatedObject overlap = iter.next();
            for (BaseString key : this.m_MetaDataKeys) {
                if (!overlap.getMetaData().containsKey(key.getValue())) continue;
                ((LocatedObject)objects.get(index)).getMetaData().put(key.getValue(), overlap.getMetaData().get(key.getValue()));
            }
        }
        return objects;
    }
}

