/*
 * Decompiled with CFR 0.152.
 */
package adams.data.objectfilter;

import adams.data.objectfilter.AbstractObjectFilter;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;

public class ClipBoundingBoxes
extends AbstractObjectFilter {
    private static final long serialVersionUID = -2181381799680316619L;
    protected int m_Width;
    protected int m_Height;

    public String globalInfo() {
        return "Ensures that bounding boxes fall within the image boundaries.\nAutomatically removes invalid polygons that require clipping and any bounding boxes that have width or height of zero.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("width", "width", (Object)1000, (Number)1, null);
        this.m_OptionManager.add("height", "height", (Object)1000, (Number)1, null);
    }

    public void setWidth(int value) {
        this.m_Width = value;
        this.reset();
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the image to use.";
    }

    public void setHeight(int value) {
        this.m_Height = value;
        this.reset();
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the image to use.";
    }

    @Override
    protected LocatedObjects doFilter(LocatedObjects objects) {
        LocatedObjects result = new LocatedObjects();
        for (LocatedObject object : objects) {
            boolean update = false;
            int x0 = object.getX();
            int y0 = object.getY();
            int x1 = x0 + object.getWidth() - 1;
            int y1 = y0 + object.getHeight() - 1;
            if (x0 < 0) {
                x0 = 0;
                update = true;
            }
            if (x0 >= this.m_Width) {
                x0 = this.m_Width - 1;
                update = true;
            }
            if (y0 < 0) {
                y0 = 0;
                update = true;
            }
            if (y0 >= this.m_Height) {
                y0 = this.m_Height - 1;
                update = true;
            }
            if (x1 < 0) {
                x1 = 0;
                update = true;
            }
            if (x1 >= this.m_Width) {
                x1 = this.m_Width - 1;
                update = true;
            }
            if (y1 < 0) {
                y1 = 0;
                update = true;
            }
            if (y1 >= this.m_Height) {
                y1 = this.m_Height - 1;
                update = true;
            }
            if (update) {
                if (x0 == x1 || y0 == y1) continue;
                LocatedObject fixed = new LocatedObject(object.getImage(), x0, y0, x1 - x0 + 1, y1 - y0 + 1, object.getMetaData(true));
                result.add(fixed);
                continue;
            }
            result.add(object.getClone());
        }
        return result;
    }
}

