/*
 * Decompiled with CFR 0.152.
 */
package adams.data.objectfilter;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.objectfilter.AbstractObjectFilter;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;

public class OffsetIndex
extends AbstractObjectFilter {
    private static final long serialVersionUID = -2181381799680316619L;
    protected int m_Offset;

    public String globalInfo() {
        return "Offsets the object index. Useful when merging multiple reports.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("offset", "offset", (Object)0);
    }

    public void setOffset(int value) {
        if (this.getOptionManager().isValid("offset", (Number)value)) {
            this.m_Offset = value;
            this.reset();
        }
    }

    public int getOffset() {
        return this.m_Offset;
    }

    public String offsetTipText() {
        return "The offset for the index.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"offset", (Object)this.m_Offset, (String)"x: ");
    }

    @Override
    protected LocatedObjects doFilter(LocatedObjects objects) {
        LocatedObjects result = new LocatedObjects();
        for (LocatedObject obj : objects) {
            LocatedObject newObj = obj.getClone();
            newObj.getMetaData().put("index", "" + (obj.getIndex() + this.m_Offset));
            result.add(newObj);
        }
        return result;
    }
}

