/*
 * Decompiled with CFR 0.152.
 */
package adams.data.objectfilter;

import adams.core.Utils;
import adams.data.objectfilter.AbstractObjectFilter;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;

public class RemoveDuplicatePolygonPoints
extends AbstractObjectFilter {
    private static final long serialVersionUID = -7765505197662180885L;

    public String globalInfo() {
        return "Removes duplicate points from polygons, e.g., introduced during scaling.";
    }

    @Override
    protected LocatedObjects doFilter(LocatedObjects objects) {
        LocatedObjects result = new LocatedObjects();
        for (LocatedObject objOld : objects) {
            LocatedObject objNew = objOld.getClone();
            if (objNew.hasPolygon()) {
                int[] oldX = objOld.getPolygonX();
                int[] oldY = objOld.getPolygonY();
                ArrayList<Integer> newX = new ArrayList<Integer>();
                ArrayList<Integer> newY = new ArrayList<Integer>();
                HashSet<Point2D.Double> points = new HashSet<Point2D.Double>();
                for (int i = 0; i < oldX.length; ++i) {
                    Point2D.Double point = new Point2D.Double(oldX[i], oldY[i]);
                    if (points.contains(point)) continue;
                    newX.add(oldX[i]);
                    newY.add(oldY[i]);
                    points.add(point);
                }
                objNew.getMetaData().put("poly_x", Utils.flatten((Object[])newX.toArray(), (String)","));
                objNew.getMetaData().put("poly_y", Utils.flatten((Object[])newY.toArray(), (String)","));
                if (this.isLoggingEnabled() && oldX.length != newX.size()) {
                    this.getLogger().info(objOld.getIndexString() + ": " + oldX.length + " -> " + newX.size());
                }
            }
            result.add(objNew);
        }
        return result;
    }
}

