/*
 * Decompiled with CFR 0.152.
 */
package adams.data.objectfinder;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.objectfinder.AbstractObjectFinder;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import gnu.trove.list.array.TIntArrayList;

public class ByMetaDataNumericValue
extends AbstractObjectFinder {
    private static final long serialVersionUID = 235661615457187608L;
    public static final String NAN = "NaN";
    protected String m_Key;
    protected double m_Minimum;
    protected boolean m_MinimumIncluded;
    protected double m_Maximum;
    protected boolean m_MaximumIncluded;

    public String globalInfo() {
        return "Returns the indices of objects which numeric meta-data value match the min/max.x/y/width/height can also be used as key.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("key", "key", (Object)"");
        this.m_OptionManager.add("minimum", "minimum", (Object)Double.NaN);
        this.m_OptionManager.add("minimum-included", "minimumIncluded", (Object)false);
        this.m_OptionManager.add("maximum", "maximum", (Object)Double.NaN);
        this.m_OptionManager.add("maximum-included", "maximumIncluded", (Object)false);
    }

    public void setKey(String value) {
        this.m_Key = value;
        this.reset();
    }

    public String getKey() {
        return this.m_Key;
    }

    public String keyTipText() {
        return "The meta-data key to check.";
    }

    public void setMinimum(double value) {
        this.m_Minimum = value;
        this.reset();
    }

    public double getMinimum() {
        return this.m_Minimum;
    }

    public String minimumTipText() {
        return "The minimum value that the values must satisfy; use NaN (not a number) to ignore minimum.";
    }

    public void setMinimumIncluded(boolean value) {
        this.m_MinimumIncluded = value;
        this.reset();
    }

    public boolean getMinimumIncluded() {
        return this.m_MinimumIncluded;
    }

    public String minimumIncludedTipText() {
        return "If enabled, then the minimum value gets included (testing '<=' rather than '<').";
    }

    public void setMaximum(double value) {
        this.m_Maximum = value;
        this.reset();
    }

    public double getMaximum() {
        return this.m_Maximum;
    }

    public String maximumTipText() {
        return "The maximum value that the values must satisfy; use NaN (not a number) to ignore maximum.";
    }

    public void setMaximumIncluded(boolean value) {
        this.m_MaximumIncluded = value;
        this.reset();
    }

    public boolean getMaximumIncluded() {
        return this.m_MaximumIncluded;
    }

    public String maximumIncludedTipText() {
        return "If enabled, then the maximum value gets included (testing '>=' rather than '>').";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"key", (Object)this.m_Key, (String)", key: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"minimum", (Object)this.m_Minimum, (String)", min: ");
        result = result + " [" + QuickInfoHelper.toString((OptionHandler)this, (String)"minimumIncluded", (Object)(this.m_MinimumIncluded ? "incl" : "excl")) + "]";
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"maximum", (Object)this.m_Maximum, (String)", max: ");
        result = result + " [" + QuickInfoHelper.toString((OptionHandler)this, (String)"maximumIncluded", (Object)(this.m_MaximumIncluded ? "incl" : "excl")) + "]";
        return result;
    }

    @Override
    protected int[] doFind(LocatedObjects objects) {
        TIntArrayList result = new TIntArrayList();
        for (LocatedObject obj : objects) {
            if (obj.getMetaData() == null) continue;
            boolean add = false;
            String valueStr = "";
            if (obj.getMetaData().containsKey(this.m_Key)) {
                valueStr = "" + obj.getMetaData().get(this.m_Key);
                add = true;
            } else if (this.m_Key.equalsIgnoreCase("width")) {
                valueStr = "" + obj.getWidth();
                add = true;
            } else if (this.m_Key.equalsIgnoreCase("height")) {
                valueStr = "" + obj.getHeight();
                add = true;
            } else if (this.m_Key.equalsIgnoreCase("x")) {
                valueStr = "" + obj.getX();
                add = true;
            } else if (this.m_Key.equals("y")) {
                valueStr = "" + obj.getY();
                add = true;
            }
            if (!add) continue;
            if (!Utils.isDouble((String)valueStr)) {
                add = false;
            } else {
                try {
                    double value = Double.parseDouble(valueStr);
                    if (!Double.isNaN(this.m_Minimum)) {
                        if (this.m_MinimumIncluded) {
                            if (value < this.m_Minimum) {
                                add = false;
                            }
                        } else if (value <= this.m_Minimum) {
                            add = false;
                        }
                    }
                    if (!Double.isNaN(this.m_Maximum)) {
                        if (this.m_MaximumIncluded) {
                            if (value > this.m_Maximum) {
                                add = false;
                            }
                        } else if (value >= this.m_Maximum) {
                            add = false;
                        }
                    }
                }
                catch (Exception e) {
                    add = false;
                }
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info(obj.getIndex() + ". '" + valueStr + "' fits: " + add);
            }
            if (!add) continue;
            result.add(obj.getIndex());
        }
        return result.toArray();
    }
}

