/*
 * Decompiled with CFR 0.152.
 */
package adams.data.objectfinder;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.objectfinder.AbstractObjectFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.flow.transformer.locateobjects.LocatedObjects;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;

public class MultiObjectFinder
extends AbstractObjectFinder {
    private static final long serialVersionUID = 1441664440186470414L;
    protected ObjectFinder[] m_Finders;
    protected Combination m_Combination;

    public String globalInfo() {
        return "Applies multiple object finding algorithms to the data.\nThe indices can be either joined or intersected.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finders", (Object)new ObjectFinder[0]);
        this.m_OptionManager.add("combination", "combination", (Object)Combination.JOIN);
    }

    public void setFinders(ObjectFinder[] value) {
        this.m_Finders = value;
        this.reset();
    }

    public ObjectFinder[] getFinders() {
        return this.m_Finders;
    }

    public String findersTipText() {
        return "The row finders to use.";
    }

    public void setCombination(Combination value) {
        this.m_Combination = value;
        this.reset();
    }

    public Combination getCombination() {
        return this.m_Combination;
    }

    public String combinationTipText() {
        return "Defines how the indices are combined.";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"combination", (Object)((Object)this.m_Combination), (String)", combination: ");
        return result;
    }

    @Override
    protected int[] doFind(LocatedObjects objects) {
        TIntHashSet all = new TIntHashSet();
        block4: for (int i = 0; i < this.m_Finders.length; ++i) {
            int[] indicesArray = this.m_Finders[i].find(objects);
            if (i == 0) {
                all.addAll(indicesArray);
                continue;
            }
            switch (this.m_Combination) {
                case JOIN: {
                    all.addAll(indicesArray);
                    continue block4;
                }
                case INTERSECT: {
                    all.retainAll(indicesArray);
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Unhandled combination: " + (Object)((Object)this.m_Combination));
                }
            }
        }
        int[] result = all.toArray();
        if (result.length > 1) {
            Arrays.sort(result);
        }
        return result;
    }

    public static enum Combination {
        JOIN,
        INTERSECT;

    }
}

