/*
 * Decompiled with CFR 0.152.
 */
package adams.data.objectoverlap;

import adams.core.base.BaseString;
import adams.core.option.AbstractOptionHandler;
import adams.data.objectoverlap.ObjectOverlap;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractObjectOverlap
extends AbstractOptionHandler
implements ObjectOverlap {
    private static final long serialVersionUID = -6700493470621873334L;
    protected boolean m_ExcludeIdentical;
    protected boolean m_CopyMetaData;
    protected BaseString[] m_MetaDataKeys;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("exclude-identical", "excludeIdentical", (Object)false);
        this.m_OptionManager.add("copy-meta-data", "copyMetaData", (Object)false);
        this.m_OptionManager.add("meta-data-key", "metaDataKeys", (Object)new BaseString[0]);
    }

    public void setExcludeIdentical(boolean value) {
        this.m_ExcludeIdentical = value;
        this.reset();
    }

    public boolean getExcludeIdentical() {
        return this.m_ExcludeIdentical;
    }

    public String excludeIdenticalTipText() {
        return "If enabled, identical objects are not compared with each other; e.g., when looking for overlaps within the same set of objects rather than a different set.";
    }

    public void setCopyMetaData(boolean value) {
        this.m_CopyMetaData = value;
        this.reset();
    }

    public boolean getCopyMetaData() {
        return this.m_CopyMetaData;
    }

    public String copyMetaDataTipText() {
        return "If enabled, the specified meta-data values get copied across to the object that gets returned.";
    }

    public void setMetaDataKeys(BaseString[] value) {
        this.m_MetaDataKeys = value;
        this.reset();
    }

    public BaseString[] getMetaDataKeys() {
        return this.m_MetaDataKeys;
    }

    public String metaDataKeysTipText() {
        return "The keys of the meta-data values to copy across.";
    }

    public String getQuickInfo() {
        return null;
    }

    protected String check(LocatedObjects annotations, LocatedObjects predictions) {
        if (annotations == null) {
            return "No annotations provided!";
        }
        if (predictions == null) {
            return "No predictions provided!";
        }
        return null;
    }

    protected void initMatch(Map<LocatedObject, Set<LocatedObject>> matches, LocatedObject thisObj) {
        if (!matches.containsKey(thisObj)) {
            matches.put(thisObj, new HashSet());
        }
    }

    protected void addMatch(Map<LocatedObject, Set<LocatedObject>> matches, LocatedObject thisObj, LocatedObject otherObj) {
        this.initMatch(matches, thisObj);
        matches.get(thisObj).add(otherObj);
    }

    protected abstract LocatedObjects doCalculate(LocatedObjects var1, LocatedObjects var2, Map<LocatedObject, Set<LocatedObject>> var3);

    @Override
    public LocatedObjects calculate(LocatedObjects annotations, LocatedObjects predictions) {
        String msg = this.check(annotations, predictions);
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
        return this.doCalculate(annotations, predictions, new HashMap<LocatedObject, Set<LocatedObject>>());
    }

    @Override
    public Map<LocatedObject, Set<LocatedObject>> matches(LocatedObjects annotations, LocatedObjects predictions) {
        String msg = this.check(annotations, predictions);
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
        HashMap<LocatedObject, Set<LocatedObject>> result = new HashMap<LocatedObject, Set<LocatedObject>>();
        this.doCalculate(annotations, predictions, result);
        return result;
    }

    protected void copyMetaData(LocatedObject source, LocatedObject target) {
        for (BaseString key : this.m_MetaDataKeys) {
            if (!source.getMetaData().containsKey(key.getValue())) continue;
            target.getMetaData().put(key.getValue(), source.getMetaData().get(key.getValue()));
        }
    }
}

