/*
 * Decompiled with CFR 0.152.
 */
package adams.data.overlappingobjectremoval;

import adams.data.overlappingobjectremoval.AbstractOverlappingObjectRemoval;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.util.Map;
import java.util.Set;

public class RemoveLargerRectangle
extends AbstractOverlappingObjectRemoval {
    private static final long serialVersionUID = -895136411948961806L;

    public String globalInfo() {
        return "Keeps the smallest rectangle, removes larger rectangle(s).";
    }

    @Override
    public LocatedObjects removeOverlaps(LocatedObjects objects, Map<LocatedObject, Set<LocatedObject>> matches) {
        LocatedObjects result = new LocatedObjects();
        for (LocatedObject thisObj : objects) {
            Set<LocatedObject> others = matches.get(thisObj);
            if (others != null && others.size() > 0) {
                LocatedObject smallest = thisObj;
                double thisArea = thisObj.getWidth() * thisObj.getHeight();
                for (LocatedObject otherObj : others) {
                    double otherArea = otherObj.getWidth() * otherObj.getHeight();
                    if (!(otherArea < thisArea)) continue;
                    smallest = otherObj;
                    thisArea = otherArea;
                }
                result.add(smallest.getClone());
                continue;
            }
            result.add(thisObj.getClone());
        }
        return result;
    }
}

