/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.transformer.exiftagoperation.ApacheCommonsExifTagExists;
import adams.flow.transformer.exiftagoperation.ExifTagExistsOperation;

public class HasExifTag
extends AbstractBooleanCondition {
    private static final long serialVersionUID = -8641162903464692580L;
    protected ExifTagExistsOperation m_Operation;

    public String globalInfo() {
        return "Checks whether the specified EXIF tag is present.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("operation", "operation", (Object)new ApacheCommonsExifTagExists());
    }

    public void setOperation(ExifTagExistsOperation value) {
        this.m_Operation = value;
        this.reset();
    }

    public ExifTagExistsOperation getOperation() {
        return this.m_Operation;
    }

    public String operationTipText() {
        return "The operation to execute.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"operation", (Object)this.m_Operation, (String)"operation: ");
    }

    public Class[] accepts() {
        return this.m_Operation.accepts();
    }

    protected boolean doEvaluate(Actor owner, Token token) {
        MessageCollection errors = new MessageCollection();
        Boolean result = (Boolean)this.m_Operation.process(token.getPayload(), errors);
        if (result == null) {
            result = false;
        }
        if (!errors.isEmpty()) {
            this.getLogger().severe(errors.toString());
            result = false;
        }
        return result;
    }
}

