/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.data.image.AbstractImageContainer;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import adams.gui.visualization.image.HistogramPanel;
import java.awt.Component;
import javax.swing.JComponent;

public class ImageHistogram
extends AbstractGraphicalDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = -724041933659541058L;

    public String globalInfo() {
        return "Displays a histogram of a gray image or histograms per channel for color image.";
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class};
    }

    protected BasePanel newPanel() {
        return new HistogramPanel();
    }

    protected void display(Token token) {
        AbstractImageContainer cont = (AbstractImageContainer)token.getPayload();
        HistogramPanel panel = (HistogramPanel)this.m_Panel;
        panel.setImage(cont.toBufferedImage());
    }

    public void clearPanel() {
        ((HistogramPanel)this.m_Panel).setImage(null);
    }

    public DisplayPanel createDisplayPanel(Token token) {
        AbstractComponentDisplayPanel result = new AbstractComponentDisplayPanel(((Object)((Object)this)).getClass().getSimpleName()){
            HistogramPanel m_Panel;

            public void display(Token token) {
                AbstractImageContainer cont = (AbstractImageContainer)token.getPayload();
                this.m_Panel = new HistogramPanel();
                this.m_Panel.setImage(cont.toBufferedImage());
                this.add((Component)((Object)this.m_Panel), "Center");
            }

            public void clearPanel() {
                if (this.m_Panel != null) {
                    this.m_Panel.setImage(null);
                }
            }

            public JComponent supplyComponent() {
                if (this.m_Panel != null) {
                    return this.m_Panel;
                }
                return null;
            }

            public void cleanUp() {
                if (this.m_Panel != null) {
                    this.m_Panel.setImage(null);
                }
            }
        };
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }
}

