/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.io.output.AbstractImageSegmentationAnnotationWriter;
import adams.data.io.output.IndividualImageSegmentationLayerWriter;
import adams.flow.container.ImageSegmentationContainer;
import adams.flow.sink.AbstractFileWriter;

public class ImageSegmentationFileWriter
extends AbstractFileWriter {
    private static final long serialVersionUID = 7466006970025235243L;
    protected AbstractImageSegmentationAnnotationWriter m_Writer;

    public String globalInfo() {
        return "Write image segmentation containers using the specified writer.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("writer", "writer", (Object)new IndividualImageSegmentationLayerWriter());
    }

    public String outputFileTipText() {
        return "The file to write to (other files may get generated based on writer).";
    }

    public void setWriter(AbstractImageSegmentationAnnotationWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public AbstractImageSegmentationAnnotationWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The image segmentation writer to use.";
    }

    public Class[] accepts() {
        return new Class[]{ImageSegmentationContainer.class};
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"writer", (Object)((Object)this.m_Writer));
    }

    protected String doExecute() {
        String result;
        ImageSegmentationContainer cont = (ImageSegmentationContainer)((Object)this.m_InputToken.getPayload(ImageSegmentationContainer.class));
        try {
            result = this.m_Writer.write(this.m_OutputFile, cont);
        }
        catch (Exception e) {
            result = this.handleException("Failed to write image segmentation data to file: " + this.m_OutputFile, e);
        }
        return result;
    }
}

