/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.VariableName;
import adams.core.option.OptionHandler;
import adams.event.VariableChangeEvent;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.core.VariableMonitor;
import adams.flow.transformer.AbstractTransformer;
import adams.gui.visualization.core.ColorProviderWithNameSupport;
import adams.gui.visualization.core.DefaultColorProvider;
import java.awt.Color;
import java.util.Hashtable;

public class ColorProvider
extends AbstractTransformer
implements VariableMonitor {
    private static final long serialVersionUID = -3505768725369077351L;
    public static final String BACKUP_PROVIDER = "provider";
    protected adams.gui.visualization.core.ColorProvider m_Provider;
    protected adams.gui.visualization.core.ColorProvider m_ActualProvider;
    protected VariableName m_VariableName;

    public String globalInfo() {
        return "Outputs a color for each token passing through.\nIf the color provider implements " + Utils.classToString(ColorProviderWithNameSupport.class) + " then the color associated with the incoming string token is forwarded.\nThe color provider can be reset using the specified variable.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add(BACKUP_PROVIDER, BACKUP_PROVIDER, (Object)new DefaultColorProvider());
        this.m_OptionManager.add("var-name", "variableName", (Object)new VariableName());
    }

    protected void reset() {
        super.reset();
        this.m_ActualProvider = null;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_PROVIDER);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_ActualProvider != null) {
            result.put(BACKUP_PROVIDER, this.m_ActualProvider);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_PROVIDER)) {
            this.m_InputToken = (Token)state.get(BACKUP_PROVIDER);
            state.remove(BACKUP_PROVIDER);
        }
        super.restoreState(state);
    }

    public void setProvider(adams.gui.visualization.core.ColorProvider value) {
        this.m_Provider = value;
        this.reset();
    }

    public adams.gui.visualization.core.ColorProvider getProvider() {
        return this.m_Provider;
    }

    public String providerTipText() {
        return "The color provider to use for generating the colors.";
    }

    public void setVariableName(VariableName value) {
        this.m_VariableName = value;
        this.reset();
    }

    public VariableName getVariableName() {
        return this.m_VariableName;
    }

    public String variableNameTipText() {
        return "The variable to monitor.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)BACKUP_PROVIDER, (Object)this.m_Provider);
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"variableName", (Object)this.m_VariableName.paddedValue(), (String)", variable: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    public Class[] generates() {
        return new Class[]{Color.class};
    }

    public void variableChanged(VariableChangeEvent e) {
        super.variableChanged(e);
        if ((e.getType() == VariableChangeEvent.Type.MODIFIED || e.getType() == VariableChangeEvent.Type.ADDED) && e.getName().equals(this.m_VariableName.getValue()) && this.m_ActualProvider != null) {
            this.m_ActualProvider.resetColors();
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Color provider reset");
            }
        }
    }

    protected String doExecute() {
        String result = null;
        Object input = this.m_InputToken.getPayload();
        if (this.m_ActualProvider == null) {
            this.m_ActualProvider = (adams.gui.visualization.core.ColorProvider)this.m_Provider.shallowCopy();
        }
        this.m_OutputToken = this.m_ActualProvider instanceof ColorProviderWithNameSupport && input instanceof String ? new Token((Object)((ColorProviderWithNameSupport)this.m_ActualProvider).next((String)input)) : new Token((Object)this.m_ActualProvider.next());
        return result;
    }
}

