/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.ObjectCopyHelper;
import adams.core.QuickInfoHelper;
import adams.core.base.BaseString;
import adams.core.option.OptionHandler;
import adams.data.conversion.MapToJson;
import adams.data.image.AbstractImageContainer;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInteractiveTransformerDialog;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseDialog;
import adams.gui.core.BasePanel;
import adams.gui.visualization.image.interactionlogging.InteractionEvent;
import adams.gui.visualization.image.interactionlogging.InteractionLoggingFilter;
import adams.gui.visualization.image.interactionlogging.Null;
import adams.gui.visualization.object.ObjectAnnotationPanel;
import adams.gui.visualization.object.annotationsdisplay.DefaultAnnotationsDisplayGenerator;
import adams.gui.visualization.object.annotator.ClassificationLabelAnnotator;
import adams.gui.visualization.object.labelselector.AbstractLabelSelectorGenerator;
import adams.gui.visualization.object.labelselector.ButtonSelectorGenerator;
import adams.gui.visualization.object.labelselector.ComboBoxSelectorGenerator;
import adams.gui.visualization.object.mouseclick.NullProcessor;
import adams.gui.visualization.object.overlay.ClassificationLabelTextOverlay;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JPanel;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;

public class ImageLabeler
extends AbstractInteractiveTransformerDialog {
    private static final long serialVersionUID = -3374468402777151698L;
    public static final String FIELD_INTERACTIONLOG = "interaction-log";
    protected Field m_Field;
    protected BaseString[] m_Labels;
    protected boolean m_UseButtons;
    protected ClassificationLabelTextOverlay m_Overlay;
    protected int m_LeftDividerLocation;
    protected int m_RightDividerLocation;
    protected double m_Zoom;
    protected boolean m_BestFit;
    protected InteractionLoggingFilter m_InteractionLoggingFilter;
    protected boolean m_Accepted;
    protected transient Date m_StartTimestamp;
    protected ObjectAnnotationPanel m_PanelObjectAnnotation;

    public String globalInfo() {
        return "Allows the user to label images, setting a report field in the meta-data.\nAny logged interaction will get added as JSON under interaction-log in the report.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("field", "field", (Object)new Field("Classification", DataType.STRING));
        this.m_OptionManager.add("label", "labels", (Object)new BaseString[0]);
        this.m_OptionManager.add("use-buttons", "useButtons", (Object)true);
        this.m_OptionManager.add("overlay", "overlay", (Object)new ClassificationLabelTextOverlay());
        this.m_OptionManager.add("left-divider-location", "leftDividerLocation", (Object)200, (Number)1, null);
        this.m_OptionManager.add("right-divider-location", "rightDividerLocation", (Object)900, (Number)1, null);
        this.m_OptionManager.add("zoom", "zoom", (Object)100.0, (Number)1.0, (Number)1600.0);
        this.m_OptionManager.add("best-fit", "bestFit", (Object)false);
        this.m_OptionManager.add("interaction-logging-filter", "interactionLoggingFilter", (Object)new Null());
    }

    protected int getDefaultX() {
        return -2;
    }

    protected int getDefaultY() {
        return -2;
    }

    protected int getDefaultWidth() {
        return 1200;
    }

    protected int getDefaultHeight() {
        return 800;
    }

    public void setField(Field value) {
        if (value.getDataType() == DataType.STRING) {
            this.m_Field = value;
            this.reset();
        } else {
            this.getLogger().warning("Data type of field must be string, but received: " + value);
        }
    }

    public Field getField() {
        return this.m_Field;
    }

    public String fieldTipText() {
        return "The field to use for the chosen label.";
    }

    public void setLabels(BaseString[] value) {
        this.m_Labels = value;
        this.reset();
    }

    public BaseString[] getLabels() {
        return this.m_Labels;
    }

    public String labelsTipText() {
        return "The labels to use.";
    }

    public void setUseButtons(boolean value) {
        this.m_UseButtons = value;
        this.reset();
    }

    public boolean getUseButtons() {
        return this.m_UseButtons;
    }

    public String useButtonsTipText() {
        return "If enabled, buttons are used for selecting the label rather than a drop-down list.";
    }

    public void setOverlay(ClassificationLabelTextOverlay value) {
        this.m_Overlay = value;
        this.reset();
    }

    public ClassificationLabelTextOverlay getOverlay() {
        return this.m_Overlay;
    }

    public String overlayTipText() {
        return "The overlay to use.";
    }

    public void setLeftDividerLocation(int value) {
        if (this.getOptionManager().isValid("leftDividerLocation", (Number)value)) {
            this.m_LeftDividerLocation = value;
            this.reset();
        }
    }

    public int getLeftDividerLocation() {
        return this.m_LeftDividerLocation;
    }

    public String leftDividerLocationTipText() {
        return "The position for the left divider in pixels.";
    }

    public void setRightDividerLocation(int value) {
        if (this.getOptionManager().isValid("rightDividerLocation", (Number)value)) {
            this.m_RightDividerLocation = value;
            this.reset();
        }
    }

    public int getRightDividerLocation() {
        return this.m_RightDividerLocation;
    }

    public String rightDividerLocationTipText() {
        return "The position for the right divider in pixels.";
    }

    public void setZoom(double value) {
        if (this.getOptionManager().isValid("zoom", (Number)value)) {
            this.m_Zoom = value;
            this.reset();
        }
    }

    public double getZoom() {
        return this.m_Zoom;
    }

    public String zoomTipText() {
        return "The zoom level in percent.";
    }

    public void setBestFit(boolean value) {
        this.m_BestFit = value;
        this.reset();
    }

    public boolean getBestFit() {
        return this.m_BestFit;
    }

    public String bestFitTipText() {
        return "If enabled, the image gets fitted into the viewport.";
    }

    public void setInteractionLoggingFilter(InteractionLoggingFilter value) {
        this.m_InteractionLoggingFilter = value;
        this.reset();
    }

    public InteractionLoggingFilter getInteractionLoggingFilter() {
        return this.m_InteractionLoggingFilter;
    }

    public String interactionLoggingFilterTipText() {
        return "The interaction logger to use.";
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"labels", (Object)this.m_Labels, (String)", labels: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"useButtons", (Object)(this.m_UseButtons ? "buttons" : "drop-down list"), (String)", ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class};
    }

    public Class[] generates() {
        return new Class[]{AbstractImageContainer.class};
    }

    public void clearPanel() {
    }

    protected BasePanel newPanel() {
        AbstractLabelSelectorGenerator labelSelector;
        this.m_PanelObjectAnnotation = new ObjectAnnotationPanel();
        this.m_PanelObjectAnnotation.setAnnotationsPanel(new DefaultAnnotationsDisplayGenerator().generate());
        if (this.m_UseButtons) {
            labelSelector = new ButtonSelectorGenerator();
            ((ButtonSelectorGenerator)labelSelector).setLabels(this.m_Labels);
        } else {
            labelSelector = new ComboBoxSelectorGenerator();
            ((ComboBoxSelectorGenerator)labelSelector).setLabels(this.m_Labels);
        }
        this.m_PanelObjectAnnotation.setLabelSelectorPanel(labelSelector.generate(this.m_PanelObjectAnnotation));
        ClassificationLabelAnnotator annotator = new ClassificationLabelAnnotator();
        annotator.setField(this.m_Field);
        this.m_PanelObjectAnnotation.setAnnotator(annotator);
        ClassificationLabelTextOverlay overlay = (ClassificationLabelTextOverlay)((Object)ObjectCopyHelper.copyObject((Object)((Object)this.m_Overlay)));
        overlay.setField(this.m_Field);
        this.m_PanelObjectAnnotation.setOverlay(overlay);
        this.m_PanelObjectAnnotation.setMouseClickProcessor(new NullProcessor());
        this.m_PanelObjectAnnotation.setZoom(this.m_Zoom / 100.0);
        this.m_PanelObjectAnnotation.setBestFit(this.m_BestFit);
        this.m_PanelObjectAnnotation.setInteractionLoggingFilter((InteractionLoggingFilter)ObjectCopyHelper.copyObject((Object)this.m_InteractionLoggingFilter));
        this.m_PanelObjectAnnotation.setLeftDividerLocation(this.m_LeftDividerLocation);
        this.m_PanelObjectAnnotation.setRightDividerLocation(this.m_RightDividerLocation - this.m_LeftDividerLocation);
        return this.m_PanelObjectAnnotation;
    }

    protected void postCreateDialog(BaseDialog dialog, BasePanel panel) {
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        dialog.getContentPane().add((Component)panelButtons, "South");
        BaseButton buttonOK = new BaseButton("OK");
        buttonOK.addActionListener(e -> {
            this.m_Accepted = true;
            dialog.setVisible(false);
        });
        panelButtons.add((Component)buttonOK);
        BaseButton buttonCancel = new BaseButton("Cancel");
        buttonCancel.addActionListener(e -> {
            this.m_Accepted = false;
            dialog.setVisible(false);
        });
        panelButtons.add((Component)buttonCancel);
    }

    protected void addInterationsToReport(Report report, List<InteractionEvent> events) {
        JSONObject interaction;
        String value;
        if (events == null) {
            return;
        }
        JSONArray array = new JSONArray();
        MapToJson m2j = new MapToJson();
        DateFormat formatter = DateUtils.getTimestampFormatterMsecs();
        Field field = new Field(FIELD_INTERACTIONLOG, DataType.STRING);
        if (report.hasValue((AbstractField)field) && (value = "" + report.getValue((AbstractField)field)).length() > 0) {
            try {
                JSONParser parser = new JSONParser(1984);
                array = (JSONArray)parser.parse(value);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to parse old interactions: " + value, (Throwable)e);
            }
        }
        if (array.size() > 0) {
            interaction = new JSONObject();
            interaction.put((Object)"timestamp", (Object)formatter.format(this.m_StartTimestamp));
            interaction.put((Object)"id", (Object)"---");
            array.add((Object)interaction);
        }
        for (InteractionEvent event : events) {
            interaction = new JSONObject();
            interaction.put((Object)"timestamp", (Object)formatter.format(event.getTimestamp()));
            interaction.put((Object)"id", (Object)event.getID());
            if (event.getData() != null) {
                m2j.setInput((Object)event.getData());
                String msg = m2j.convert();
                if (msg == null) {
                    interaction.put((Object)"data", m2j.getOutput());
                } else {
                    this.getLogger().warning("Failed to convert interaction data to JSON: " + event.getData());
                }
            }
            array.add((Object)interaction);
        }
        report.addField((AbstractField)field);
        report.setValue((AbstractField)field, (Object)array.toString());
    }

    public boolean doInteract() {
        this.m_Accepted = false;
        AbstractImageContainer cont = (AbstractImageContainer)this.m_InputToken.getPayload();
        this.m_StartTimestamp = new Date();
        this.registerWindow((Window)this.m_Dialog, this.m_Dialog.getTitle());
        this.m_PanelObjectAnnotation.clear();
        this.m_PanelObjectAnnotation.setImage(cont.toBufferedImage());
        this.m_PanelObjectAnnotation.setReport(cont.getReport().getClone());
        if (cont.getReport().hasValue(this.m_Field.getName())) {
            this.m_PanelObjectAnnotation.preselectCurrentLabel(cont.getReport().getStringValue(this.m_Field.getName()));
        } else {
            this.m_PanelObjectAnnotation.preselectCurrentLabel(null);
        }
        this.m_PanelObjectAnnotation.annotationsChanged((Object)this);
        this.m_PanelObjectAnnotation.labelChanged((Object)this);
        this.m_Dialog.setVisible(true);
        this.deregisterWindow((Window)this.m_Dialog);
        if (this.m_Accepted) {
            cont.setReport(this.m_PanelObjectAnnotation.getReport());
            if (!(this.m_InteractionLoggingFilter instanceof Null)) {
                this.addInterationsToReport(cont.getReport(), this.m_PanelObjectAnnotation.getInteractionLog());
            }
            this.m_OutputToken = new Token((Object)cont);
        }
        return this.m_Accepted;
    }
}

