/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.metadata.AbstractMetaDataExtractor;
import adams.flow.transformer.metadata.ApacheCommons;
import java.io.File;

public class ImageMetaData
extends AbstractTransformer {
    private static final long serialVersionUID = 8005075286840278197L;
    protected AbstractMetaDataExtractor m_Extractor;

    public String globalInfo() {
        return "Returns any EXIF or IPTC and basic image information as a spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("extractor", "extractor", (Object)new ApacheCommons());
    }

    public void setExtractor(AbstractMetaDataExtractor value) {
        this.m_Extractor = value;
        this.reset();
    }

    public AbstractMetaDataExtractor getExtractor() {
        return this.m_Extractor;
    }

    public String extractorTipText() {
        return "The meta-data extrator to use.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"extractor", (Object)((Object)this.m_Extractor), (String)"extractor: ");
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected String doExecute() {
        String result = null;
        File file = this.m_InputToken.getPayload() instanceof String ? new File(new PlaceholderFile((String)this.m_InputToken.getPayload()).getAbsolutePath()) : new File(((File)this.m_InputToken.getPayload()).getAbsolutePath());
        try {
            SpreadSheet sheet = this.m_Extractor.extract(file);
            this.m_OutputToken = new Token((Object)sheet);
        }
        catch (Exception e) {
            result = this.handleException("Failed to read meta-data from: " + file, e);
        }
        return result;
    }
}

