/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.objectfilter.ObjectFilter;
import adams.data.objectfilter.PassThrough;
import adams.data.objectfinder.AllFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.data.report.AbstractField;
import adams.data.report.MutableReportHandler;
import adams.data.report.Report;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.locateobjects.LocatedObjects;

public class ImageObjectFilter
extends AbstractTransformer {
    private static final long serialVersionUID = -3992867498417362738L;
    protected ObjectFinder m_Finder;
    protected ObjectFilter m_Filter;
    protected boolean m_KeepAllObjects;
    protected boolean m_CleanIndices;

    public String globalInfo() {
        return "Uses the specified object finder to locate objects and then applies the object filter to the located objects (modifies the report).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finder", (Object)new AllFinder());
        this.m_OptionManager.add("filter", "filter", (Object)new PassThrough());
        this.m_OptionManager.add("keep-all-objects", "keepAllObjects", (Object)false);
        this.m_OptionManager.add("clean-indices", "cleanIndices", (Object)false);
    }

    public void setFinder(ObjectFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public ObjectFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The object finder to use.";
    }

    public void setFilter(ObjectFilter value) {
        this.m_Filter = value;
        this.reset();
    }

    public ObjectFilter getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The object filter to apply to the located objects.";
    }

    public void setKeepAllObjects(boolean value) {
        this.m_KeepAllObjects = value;
        this.reset();
    }

    public boolean getKeepAllObjects() {
        return this.m_KeepAllObjects;
    }

    public String keepAllObjectsTipText() {
        return "If enabled, all objects are kept, ie the ones that weren't located by the object finder and the filtered ones.";
    }

    public void setCleanIndices(boolean value) {
        this.m_CleanIndices = value;
        this.reset();
    }

    public boolean getCleanIndices() {
        return this.m_CleanIndices;
    }

    public String cleanIndicesTipText() {
        return "If enabled, all potential index entries get removed from the meta-data.";
    }

    public Class[] accepts() {
        return new Class[]{Report.class, MutableReportHandler.class};
    }

    public Class[] generates() {
        return new Class[]{Report.class, MutableReportHandler.class};
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"finder", (Object)this.m_Finder, (String)"finder: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"filter", (Object)this.m_Filter, (String)", filter: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"keepAllObjects", (boolean)this.m_KeepAllObjects, (String)"keep all", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"cleanIndices", (boolean)this.m_CleanIndices, (String)"clean indices", (String)", ");
        return result;
    }

    protected String doExecute() {
        String result = null;
        Report report = null;
        MutableReportHandler handler = null;
        if (this.m_InputToken.hasPayload(MutableReportHandler.class)) {
            handler = (MutableReportHandler)this.m_InputToken.getPayload(MutableReportHandler.class);
            report = handler.getReport();
        } else if (this.m_InputToken.hasPayload(Report.class)) {
            report = (Report)this.m_InputToken.getPayload(Report.class);
        } else {
            result = this.m_InputToken.unhandledData();
        }
        if (result == null) {
            try {
                LocatedObjects objs = LocatedObjects.fromReport(report, this.m_Finder.getPrefix());
                if (this.m_CleanIndices) {
                    objs.resetIndex();
                }
                int[] indices = this.m_Finder.find(objs);
                for (AbstractField field : report.getFields()) {
                    if (!field.getName().startsWith(this.m_Finder.getPrefix())) continue;
                    report.removeValue(field);
                }
                LocatedObjects newObjs = objs.subset(indices);
                this.m_Filter.setFlowContext((Actor)this);
                newObjs = this.m_Filter.filter(newObjs);
                if (this.m_KeepAllObjects) {
                    LocatedObjects otherObjs = objs.subset(indices, true);
                    newObjs.addAll(otherObjs);
                }
                Report newReport = newObjs.toReport(this.m_Finder.getPrefix());
                for (AbstractField field : newReport.getFields()) {
                    report.addField(field);
                    report.setValue(field, newReport.getValue(field));
                }
                if (handler != null) {
                    handler.setReport(report);
                    this.m_OutputToken = new Token((Object)handler);
                } else {
                    this.m_OutputToken = new Token((Object)report);
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to filter objects!", e);
            }
        }
        return result;
    }
}

