/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseString;
import adams.data.RoundingUtils;
import adams.data.image.AbstractImageContainer;
import adams.flow.container.ImageSegmentationContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInteractiveTransformerDialog;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseDialog;
import adams.gui.core.BasePanel;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.segmentation.SegmentationPanel;
import adams.gui.visualization.segmentation.layer.AbstractLayer;
import adams.gui.visualization.segmentation.layer.BackgroundLayer;
import adams.gui.visualization.segmentation.layer.CombinedLayer;
import adams.gui.visualization.segmentation.layer.ImageLayer;
import adams.gui.visualization.segmentation.layer.OverlayLayer;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

public class ImageSegmentationAnnotator
extends AbstractInteractiveTransformerDialog {
    private static final long serialVersionUID = -761517109077084448L;
    protected BaseString[] m_Labels;
    protected ColorProvider m_ColorProvider;
    protected SegmentationPanel m_PanelSegmentation;
    protected float m_Alpha;
    protected int m_LeftDividerLocation;
    protected int m_RightDividerLocation;
    protected int m_ToolButtonColumns;
    protected boolean m_AutomaticUndo;
    protected double m_Zoom;
    protected boolean m_BestFit;
    protected boolean m_UseSeparateLayers;
    protected LayerVisibility m_LayerVisibility;
    protected boolean m_AllowLayerRemoval;
    protected boolean m_AllowLayerActions;
    protected boolean m_Accepted;
    protected List<AbstractLayer.AbstractLayerState> m_LastSettings;
    protected boolean m_BestFitApplied;
    protected ChangeListener m_BestFitRedoneListener;

    public String globalInfo() {
        return "User interface for annotating images for image segmentation.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("label", "labels", (Object)new BaseString[0]);
        this.m_OptionManager.add("color-provider", "colorProvider", (Object)new DefaultColorProvider());
        this.m_OptionManager.add("alpha", "alpha", (Object)Float.valueOf(0.5f), (Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f));
        this.m_OptionManager.add("left-divider-location", "leftDividerLocation", (Object)280, (Number)1, null);
        this.m_OptionManager.add("right-divider-location", "rightDividerLocation", (Object)650, (Number)1, null);
        this.m_OptionManager.add("tool-button-columns", "toolButtonColumns", (Object)4, (Number)1, null);
        this.m_OptionManager.add("automatic-undo", "automaticUndo", (Object)true);
        this.m_OptionManager.add("zoom", "zoom", (Object)100.0, (Number)1.0, null);
        this.m_OptionManager.add("best-fit", "bestFit", (Object)false);
        this.m_OptionManager.add("use-separate-layers", "useSeparateLayers", (Object)true);
        this.m_OptionManager.add("layer-visibility", "layerVisibility", (Object)LayerVisibility.ALL);
        this.m_OptionManager.add("allow-layer-remove", "allowLayerRemoval", (Object)false);
        this.m_OptionManager.add("allow-layer-actions", "allowLayerActions", (Object)false);
    }

    protected void reset() {
        super.reset();
        this.m_LastSettings = new ArrayList<AbstractLayer.AbstractLayerState>();
        this.m_BestFitApplied = false;
        this.m_BestFitRedoneListener = e -> {
            this.m_PanelSegmentation.setZoom(RoundingUtils.round((double)(this.m_PanelSegmentation.getManager().getZoom() * 100.0), (int)1));
            this.m_PanelSegmentation.getManager().removeBestFitRedoneListener(this.m_BestFitRedoneListener);
        };
    }

    protected int getDefaultX() {
        return -2;
    }

    protected int getDefaultY() {
        return -2;
    }

    protected int getDefaultWidth() {
        return 1200;
    }

    protected int getDefaultHeight() {
        return 800;
    }

    public void setLabels(BaseString[] value) {
        this.m_Labels = value;
        this.reset();
    }

    public BaseString[] getLabels() {
        return this.m_Labels;
    }

    public String labelsTipText() {
        return "The labels to use.";
    }

    public void setColorProvider(ColorProvider value) {
        this.m_ColorProvider = value;
        this.reset();
    }

    public ColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public String colorProviderTipText() {
        return "The color provider in use for generating the colors for the various layers.";
    }

    public void setAlpha(float value) {
        this.m_Alpha = value;
        this.reset();
    }

    public float getAlpha() {
        return this.m_Alpha;
    }

    public String alphaTipText() {
        return "The alpha value to use (fully transparent=0.0, fully opaque=1.0).";
    }

    public void setLeftDividerLocation(int value) {
        if (this.getOptionManager().isValid("leftDividerLocation", (Number)value)) {
            this.m_LeftDividerLocation = value;
            this.reset();
        }
    }

    public int getLeftDividerLocation() {
        return this.m_LeftDividerLocation;
    }

    public String leftDividerLocationTipText() {
        return "The position for the left divider in pixels.";
    }

    public void setRightDividerLocation(int value) {
        if (this.getOptionManager().isValid("rightDividerLocation", (Number)value)) {
            this.m_RightDividerLocation = value;
            this.reset();
        }
    }

    public int getRightDividerLocation() {
        return this.m_RightDividerLocation;
    }

    public String rightDividerLocationTipText() {
        return "The position for the right divider in pixels.";
    }

    public void setToolButtonColumns(int value) {
        if (this.getOptionManager().isValid("toolButtonColumns", (Number)value)) {
            this.m_ToolButtonColumns = value;
            this.reset();
        }
    }

    public int getToolButtonColumns() {
        return this.m_ToolButtonColumns;
    }

    public String toolButtonColumnsTipText() {
        return "The number of columns to use for the tool buttons.";
    }

    public void setAutomaticUndo(boolean value) {
        this.m_AutomaticUndo = value;
        this.reset();
    }

    public boolean getAutomaticUndo() {
        return this.m_AutomaticUndo;
    }

    public String automaticUndoTipText() {
        return "For either using automatic undo or manual one; for large images, automatic undo can slow things down.";
    }

    public void setZoom(double value) {
        if (this.getOptionManager().isValid("zoom", (Number)value)) {
            this.m_Zoom = value;
            this.reset();
        }
    }

    public double getZoom() {
        return this.m_Zoom;
    }

    public String zoomTipText() {
        return "The zoom level in percent.";
    }

    public void setBestFit(boolean value) {
        this.m_BestFit = value;
        this.reset();
    }

    public boolean getBestFit() {
        return this.m_BestFit;
    }

    public String bestFitTipText() {
        return "If enabled, the image gets fitted into the viewport.";
    }

    public void setUseSeparateLayers(boolean value) {
        this.m_UseSeparateLayers = value;
        this.reset();
    }

    public boolean getUseSeparateLayers() {
        return this.m_UseSeparateLayers;
    }

    public String useSeparateLayersTipText() {
        return "If enabled, support for multiple layers is enabled (eg for annotating objects that do not touch/overlap).";
    }

    public void setLayerVisibility(LayerVisibility value) {
        this.m_LayerVisibility = value;
        this.reset();
    }

    public LayerVisibility getLayerVisibility() {
        return this.m_LayerVisibility;
    }

    public String layerVisibilityTipText() {
        return "What layers will be visible when annotating the next image (when using separate layers).";
    }

    public void setAllowLayerRemoval(boolean value) {
        this.m_AllowLayerRemoval = value;
        this.reset();
    }

    public boolean getAllowLayerRemoval() {
        return this.m_AllowLayerRemoval;
    }

    public String allowLayerRemovalTipText() {
        return "If enabled, the user can remove layers (when using separate layers).";
    }

    public void setAllowLayerActions(boolean value) {
        this.m_AllowLayerActions = value;
        this.reset();
    }

    public boolean getAllowLayerActions() {
        return this.m_AllowLayerActions;
    }

    public String allowLayerActionsTipText() {
        return "If enabled, the user has access to layer actions (when using separate layers).";
    }

    public Class[] accepts() {
        return new Class[]{BufferedImage.class, AbstractImageContainer.class, ImageSegmentationContainer.class};
    }

    public Class[] generates() {
        return new Class[]{ImageSegmentationContainer.class};
    }

    public void clearPanel() {
        if (this.m_PanelSegmentation != null) {
            this.m_PanelSegmentation.getManager().clear();
            this.m_PanelSegmentation.update();
        }
    }

    protected BasePanel newPanel() {
        this.m_PanelSegmentation = new SegmentationPanel();
        this.m_PanelSegmentation.setZoom(this.m_Zoom);
        this.m_PanelSegmentation.getManager().setSplitLayers(this.m_UseSeparateLayers);
        this.m_PanelSegmentation.setLeftDividerLocation(this.m_LeftDividerLocation);
        this.m_PanelSegmentation.setRightDividerLocation(this.m_RightDividerLocation);
        this.m_PanelSegmentation.setToolButtonColumns(this.m_ToolButtonColumns);
        this.m_PanelSegmentation.setAutomaticUndoEnabled(this.m_AutomaticUndo);
        return this.m_PanelSegmentation;
    }

    protected void postCreateDialog(BaseDialog dialog, BasePanel panel) {
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        dialog.getContentPane().add((Component)panelButtons, "South");
        BaseButton buttonOK = new BaseButton("OK");
        buttonOK.addActionListener(e -> {
            this.m_Accepted = true;
            dialog.setVisible(false);
        });
        panelButtons.add((Component)buttonOK);
        BaseButton buttonCancel = new BaseButton("Cancel");
        buttonCancel.addActionListener(e -> {
            this.m_Accepted = false;
            dialog.setVisible(false);
        });
        panelButtons.add((Component)buttonCancel);
    }

    public boolean doInteract() {
        ImageSegmentationContainer segcont;
        this.m_Accepted = false;
        if (this.m_InputToken.hasPayload(BufferedImage.class)) {
            BufferedImage img = (BufferedImage)this.m_InputToken.getPayload(BufferedImage.class);
            segcont = new ImageSegmentationContainer("image", img);
        } else if (this.m_InputToken.hasPayload(AbstractImageContainer.class)) {
            AbstractImageContainer imgcont = (AbstractImageContainer)this.m_InputToken.getPayload(AbstractImageContainer.class);
            segcont = new ImageSegmentationContainer("image", imgcont.toBufferedImage());
        } else {
            segcont = (ImageSegmentationContainer)((Object)this.m_InputToken.getPayload(ImageSegmentationContainer.class));
        }
        this.registerWindow((Window)this.m_Dialog, this.m_Dialog.getTitle());
        this.m_ColorProvider.resetColors();
        this.m_PanelSegmentation.getManager().clear();
        this.m_PanelSegmentation.getManager().setImage((String)segcont.getValue("name", String.class), (BufferedImage)segcont.getValue("base", BufferedImage.class));
        HashMap<String, BufferedImage> layers = (HashMap<String, BufferedImage>)segcont.getValue("layers");
        block9: for (BaseString label : this.m_Labels) {
            if (this.m_UseSeparateLayers) {
                OverlayLayer layer;
                if (layers != null) {
                    if (layers.containsKey(label.getValue())) {
                        layer = this.m_PanelSegmentation.getManager().addOverlay(label.getValue(), this.m_ColorProvider.next(), this.m_Alpha, (BufferedImage)layers.get(label.getValue()));
                    } else {
                        this.getLogger().warning("Label '" + label + "' not present in layers, using empty layer!");
                        layer = this.m_PanelSegmentation.getManager().addOverlay(label.getValue(), this.m_ColorProvider.next(), this.m_Alpha);
                    }
                } else {
                    layer = this.m_PanelSegmentation.getManager().addOverlay(label.getValue(), this.m_ColorProvider.next(), this.m_Alpha);
                }
                layer.setRemovable(this.m_AllowLayerRemoval);
                layer.setActionsAvailable(this.m_AllowLayerActions);
                switch (this.m_LayerVisibility) {
                    case ALL: {
                        layer.setEnabled(true);
                        continue block9;
                    }
                    case NONE: {
                        layer.setEnabled(false);
                        continue block9;
                    }
                    case PREVIOUSLY_VISIBLE: {
                        continue block9;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled layer visibility type: " + (Object)((Object)this.m_LayerVisibility));
                    }
                }
            }
            if (layers != null) {
                if (layers.containsKey(label.getValue())) {
                    this.m_PanelSegmentation.getManager().addCombined(label.getValue(), this.m_ColorProvider.next(), this.m_Alpha, (BufferedImage)layers.get(label.getValue()));
                    continue;
                }
                this.getLogger().warning("Label '" + label + "' not present in layers, using empty layer!");
                this.m_PanelSegmentation.getManager().addCombined(label.getValue(), this.m_ColorProvider.next(), this.m_Alpha);
                continue;
            }
            this.m_PanelSegmentation.getManager().addCombined(label.getValue(), this.m_ColorProvider.next(), this.m_Alpha);
        }
        if (!this.m_LastSettings.isEmpty()) {
            this.m_PanelSegmentation.getManager().setSettings(this.m_LastSettings);
        }
        for (AbstractLayer l : this.m_PanelSegmentation.getManager().getLayers()) {
            if (l instanceof ImageLayer || l instanceof BackgroundLayer) continue;
            switch (this.m_LayerVisibility) {
                case ALL: {
                    l.setEnabled(true);
                    break;
                }
                case NONE: {
                    l.setEnabled(false);
                }
            }
        }
        this.m_PanelSegmentation.update();
        if (this.m_BestFit && !this.m_BestFitApplied) {
            this.m_PanelSegmentation.getManager().addBestFitRedoneListener(this.m_BestFitRedoneListener);
            this.m_PanelSegmentation.bestFitZoom();
            this.m_BestFitApplied = true;
        }
        if (!this.m_PanelSegmentation.isAutomaticUndoEnabled()) {
            this.m_PanelSegmentation.addUndoPoint();
        }
        this.m_Dialog.setVisible(true);
        this.deregisterWindow((Window)this.m_Dialog);
        this.m_LastSettings = this.m_PanelSegmentation.getManager().getSettings();
        if (this.m_Accepted) {
            layers = new HashMap<String, BufferedImage>();
            if (this.m_UseSeparateLayers) {
                for (OverlayLayer l : this.m_PanelSegmentation.getManager().getOverlays()) {
                    layers.put(l.getName(), l.getBinaryImage());
                }
            } else {
                for (CombinedLayer.CombinedSubLayer l : this.m_PanelSegmentation.getManager().getCombinedLayer().getSubLayers()) {
                    layers.put(l.getName(), l.getBinaryImage());
                }
            }
            segcont = new ImageSegmentationContainer();
            segcont.setValue("base", this.m_PanelSegmentation.getManager().getImageLayer().getImage());
            segcont.setValue("layers", layers);
            this.m_OutputToken = new Token((Object)segcont);
        }
        return this.m_Accepted;
    }

    public static enum LayerVisibility {
        ALL,
        NONE,
        PREVIOUSLY_VISIBLE;

    }
}

