/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.io.input.AbstractImageSegmentationAnnotationReader;
import adams.data.io.input.IndividualImageSegmentationLayerReader;
import adams.flow.container.ImageSegmentationContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;

public class ImageSegmentationFileReader
extends AbstractTransformer {
    private static final long serialVersionUID = 7466006970025235243L;
    protected AbstractImageSegmentationAnnotationReader m_Reader;

    public String globalInfo() {
        return "Reads image segmentation file formats using the specified reader and forwards a container with the data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", (Object)new IndividualImageSegmentationLayerReader());
    }

    public void setReader(AbstractImageSegmentationAnnotationReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public AbstractImageSegmentationAnnotationReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The image segmentation reader to use.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{ImageSegmentationContainer.class};
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"reader", (Object)((Object)this.m_Reader));
    }

    protected String doExecute() {
        String result = null;
        PlaceholderFile file = this.m_InputToken.getPayload() instanceof String ? new PlaceholderFile((String)this.m_InputToken.getPayload()) : new PlaceholderFile((File)this.m_InputToken.getPayload());
        try {
            ImageSegmentationContainer cont = this.m_Reader.read(file);
            if (cont != null) {
                this.m_OutputToken = new Token((Object)cont);
            } else {
                result = "Failed to read image segmentation file: " + file;
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to read image segmentation file: " + file, e);
        }
        return result;
    }
}

