/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.annotation.DeprecatedClass;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.objectfinder.AllFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.data.objectoverlap.IntersectOverUnionRatio;
import adams.data.report.AbstractField;
import adams.data.report.MutableReportHandler;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.flow.control.StorageName;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.DetermineOverlappingObjects;
import adams.flow.transformer.locateobjects.LocatedObjects;

@DeprecatedClass(useInstead={DetermineOverlappingObjects.class, IntersectOverUnionRatio.class})
public class IntersectOverUnion
extends AbstractTransformer {
    private static final long serialVersionUID = 8175397929496972306L;
    protected StorageName m_StorageName;
    protected ObjectFinder m_Finder;
    protected double m_MinIntersectOverUnionRatio;
    protected String m_LabelKey;
    protected boolean m_UseOtherObject;
    protected boolean m_AdditionalObject;

    public String globalInfo() {
        return "Computes the Intersect Over Union (IOU) of objects with the specified report from storage.\nIt stores the iou percentage of the highest iou found (iou_highest) and the total number of iou greater than the specified minimum (iou_count).\nIf a label key (located object meta-data) has been supplied, then the label of the object with the highest iou gets stored as well (iou_label_highest) and whether the labels match (iou_label_highest_match)";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName());
        this.m_OptionManager.add("finder", "finder", (Object)new AllFinder());
        this.m_OptionManager.add("min-iou-ratio", "minIntersectOverUnionRatio", (Object)0.0, (Number)0.0, (Number)1.0);
        this.m_OptionManager.add("label-key", "labelKey", (Object)"");
        this.m_OptionManager.add("use-other-object", "useOtherObject", (Object)false);
        this.m_OptionManager.add("additional-object", "additionalObject", (Object)false);
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the storage item to merge with (Report or ReportHandler).";
    }

    public void setFinder(ObjectFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public ObjectFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The object finder for locating the objects of interest.";
    }

    public void setMinIntersectOverUnionRatio(double value) {
        if (this.getOptionManager().isValid("minIntersectOverUnionRatio", (Number)value)) {
            this.m_MinIntersectOverUnionRatio = value;
            this.reset();
        }
    }

    public double getMinIntersectOverUnionRatio() {
        return this.m_MinIntersectOverUnionRatio;
    }

    public String minIntersectOverUnionRatioTipText() {
        return "The minimum ratio that an iou must have before being considered an actual overlap.";
    }

    public void setLabelKey(String value) {
        this.m_LabelKey = value;
        this.reset();
    }

    public String getLabelKey() {
        return this.m_LabelKey;
    }

    public String labelKeyTipText() {
        return "The (optional) key for a string label in the meta-data; if supplied the value of the object with the highest iou gets stored in the report using iou_label_highest, iou_label_highest_match stores whether the labels match.";
    }

    public void setUseOtherObject(boolean value) {
        this.m_UseOtherObject = value;
        this.reset();
    }

    public boolean getUseOtherObject() {
        return this.m_UseOtherObject;
    }

    public String useOtherObjectTipText() {
        return "If enabled, the object data from the other report is used/forwarded in case of an overlap.";
    }

    public void setAdditionalObject(boolean value) {
        this.m_AdditionalObject = value;
        this.reset();
    }

    public boolean getAdditionalObject() {
        return this.m_AdditionalObject;
    }

    public String additionalObjectTipText() {
        return "If enabled, the additional predicted objects not present in actual objects will be checked.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"storageName", (Object)this.m_StorageName, (String)"storage: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"finder", (Object)this.m_Finder, (String)", finder: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"minIntersectOverUnionRatio", (Object)this.m_MinIntersectOverUnionRatio, (String)", iou ratio: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"labelKey", (Object)(this.m_LabelKey.isEmpty() ? "-none-" : this.m_LabelKey), (String)", label key: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"useOtherObject", (boolean)this.m_UseOtherObject, (String)"use other obj", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"additionalObject", (boolean)this.m_AdditionalObject, (String)"additional obj", (String)", ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class, Report.class, ReportHandler.class};
    }

    public Class[] generates() {
        return new Class[]{AbstractImageContainer.class, Report.class, ReportHandler.class};
    }

    protected String doExecute() {
        String result = null;
        Object output = null;
        Report thisReport = null;
        Report otherReport = null;
        if (this.m_InputToken.getPayload() instanceof AbstractImageContainer) {
            thisReport = ((AbstractImageContainer)this.m_InputToken.getPayload()).getReport();
        } else if (this.m_InputToken.getPayload() instanceof Report) {
            thisReport = (Report)this.m_InputToken.getPayload();
        } else if (this.m_InputToken.getPayload() instanceof ReportHandler) {
            thisReport = ((ReportHandler)this.m_InputToken.getPayload()).getReport();
        } else {
            result = "Unsupported input class: " + Utils.classToString((Object)this.m_InputToken.getPayload());
        }
        if (thisReport != null) {
            Object obj = this.getStorageHandler().getStorage().get(this.m_StorageName);
            if (obj == null) {
                result = "Failed to retrieve storage item: " + this.m_StorageName;
            } else if (obj instanceof Report) {
                otherReport = (Report)obj;
            } else if (obj instanceof ReportHandler) {
                otherReport = ((ReportHandler)obj).getReport();
            } else {
                result = "Unhandled type of storage item '" + this.m_StorageName + "': " + Utils.classToString((Object)obj);
            }
        }
        if (otherReport != null) {
            LocatedObjects thisObjs = this.m_Finder.findObjects(LocatedObjects.fromReport(thisReport, this.m_Finder.getPrefix()));
            LocatedObjects otherObjs = this.m_Finder.findObjects(LocatedObjects.fromReport(otherReport, this.m_Finder.getPrefix()));
            IntersectOverUnionRatio iouRatio = new IntersectOverUnionRatio();
            iouRatio.setMinIntersectOverUnionRatio(this.m_MinIntersectOverUnionRatio);
            iouRatio.setLabelKey(this.m_LabelKey);
            iouRatio.setUseOtherObject(this.m_UseOtherObject);
            iouRatio.setAdditionalObject(this.m_AdditionalObject);
            LocatedObjects newObjs = iouRatio.calculate(thisObjs, otherObjs);
            try {
                Report newReport = (Report)thisReport.getClass().newInstance();
                for (AbstractField field : thisReport.getFields()) {
                    if (field.getName().startsWith(this.m_Finder.getPrefix())) continue;
                    newReport.addField(field);
                    newReport.setValue(field, thisReport.getValue(field));
                }
                newReport.mergeWith(newObjs.toReport(this.m_Finder.getPrefix()));
                if (this.m_InputToken.getPayload() instanceof AbstractImageContainer) {
                    output = this.m_InputToken.getPayload();
                    ((AbstractImageContainer)output).setReport(newReport);
                } else if (this.m_InputToken.getPayload() instanceof MutableReportHandler) {
                    output = this.m_InputToken.getPayload();
                    ((MutableReportHandler)output).setReport(newReport);
                } else {
                    output = newReport;
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to create new report with updated objects!", e);
                output = null;
            }
        }
        if (output != null) {
            this.m_OutputToken = new Token(output);
        }
        return result;
    }
}

