/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.io.TempUtils;
import adams.core.io.lister.LocalDirectoryLister;
import adams.core.management.ProcessUtils;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.TesseractLanguage;
import adams.flow.core.TesseractPageSegmentation;
import adams.flow.core.Token;
import adams.flow.standalone.TesseractConfiguration;
import adams.flow.transformer.AbstractTransformer;
import com.github.fracpete.processoutput4j.output.CollectingProcessOutput;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;

public class TesseractOCR
extends AbstractTransformer {
    private static final long serialVersionUID = -5015637337437403790L;
    protected TesseractLanguage m_Language;
    protected TesseractPageSegmentation m_PageSegmentation;
    protected PlaceholderFile m_OutputBase;
    protected boolean m_OutputText;
    protected String m_Separator;
    protected boolean m_OutputHOCR;
    protected TesseractConfiguration m_Configuration;
    protected transient CollectingProcessOutput m_ProcessOutput;

    public String globalInfo() {
        return "Applies OCR to the incoming image file using Tesseract.\nIn case of successful OCR, either the file names of the generated files are broadcast or the combined text of the files.\nNB: The actor deletes all files that have the same prefix as the specified output base. Something you need to be aware of when doing OCR in parallel or generate other files with the same prefix.\n\nFor more information on tesseract see:\nhttps://github.com/tesseract-ocr/tesseract\n\n\nFor more information on hOCR see:\nhttps://en.wikipedia.org/wiki/HOCR";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("language", "language", (Object)TesseractLanguage.ENGLISH);
        this.m_OptionManager.add("page-segmentation", "pageSegmentation", (Object)TesseractPageSegmentation.FULL_AUTO_NO_OSD);
        this.m_OptionManager.add("output-base", "outputBase", (Object)new PlaceholderFile("${TMP}/outputbase"));
        this.m_OptionManager.add("output-text", "outputText", (Object)false);
        this.m_OptionManager.add("separator", "separator", (Object)"");
        this.m_OptionManager.add("output-hocr", "outputHOCR", (Object)false);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"language", (Object)((Object)this.m_Language), (String)"lang: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"pageSegmentation", (Object)((Object)this.m_PageSegmentation), (String)", psm: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputBase", (Object)this.m_OutputBase, (String)", out: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"outputText", (boolean)this.m_OutputText, (String)"output text", (String)", ");
        if (value.length() > 0) {
            result = result + value;
            value = QuickInfoHelper.toString((OptionHandler)this, (String)"separator", (Object)this.m_Separator, (String)", sep: ");
            if (value != null) {
                result = result + value;
            }
        }
        if ((value = QuickInfoHelper.toString((OptionHandler)this, (String)"outputHOCR", (boolean)this.m_OutputHOCR, (String)"hOCR", (String)", ")) != null) {
            result = result + value;
        }
        return result;
    }

    public void setLanguage(TesseractLanguage value) {
        this.m_Language = value;
        this.reset();
    }

    public TesseractLanguage getLanguage() {
        return this.m_Language;
    }

    public String languageTipText() {
        return "The language to use for OCR (must be installed).";
    }

    public void setPageSegmentation(TesseractPageSegmentation value) {
        this.m_PageSegmentation = value;
        this.reset();
    }

    public TesseractPageSegmentation getPageSegmentation() {
        return this.m_PageSegmentation;
    }

    public String pageSegmentationTipText() {
        return "The page segementation to use.";
    }

    public void setOutputBase(PlaceholderFile value) {
        this.m_OutputBase = value;
        this.reset();
    }

    public PlaceholderFile getOutputBase() {
        return this.m_OutputBase;
    }

    public String outputBaseTipText() {
        return "The base name for the generated file(s).";
    }

    public void setOutputText(boolean value) {
        this.m_OutputText = value;
        this.reset();
    }

    public boolean getOutputText() {
        return this.m_OutputText;
    }

    public String outputTextTipText() {
        return "If enabled, text combined text of all generated files is output rather than the file names.";
    }

    public void setSeparator(String value) {
        this.m_Separator = Utils.unbackQuoteChars((String)value);
        this.reset();
    }

    public String getSeparator() {
        return Utils.backQuoteChars((String)this.m_Separator);
    }

    public String separatorTipText() {
        return "The separator used between the content of two files if text rather than the file names is forwarded; you can use special characters like \\n and \\t as well";
    }

    public void setOutputHOCR(boolean value) {
        this.m_OutputHOCR = value;
        this.reset();
    }

    public boolean getOutputHOCR() {
        return this.m_OutputHOCR;
    }

    public String outputHOCRTipText() {
        return "If enabled, HTML files using the hOCR format are generated rather than ASCII files.";
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Configuration = (TesseractConfiguration)ActorUtils.findClosestType((Actor)this, TesseractConfiguration.class);
            if (this.m_Configuration == null) {
                result = "No " + TesseractConfiguration.class.getName() + " actor found!";
            }
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class, AbstractImageContainer.class};
    }

    public Class[] generates() {
        if (this.m_OutputText) {
            return new Class[]{String.class};
        }
        return new Class[]{String[].class};
    }

    protected String doExecute() {
        String result = null;
        String fileStr = null;
        File file = null;
        if (this.m_InputToken.getPayload() instanceof File) {
            fileStr = ((File)this.m_InputToken.getPayload()).getAbsolutePath();
        } else if (this.m_InputToken.getPayload() instanceof String) {
            fileStr = new PlaceholderFile((String)this.m_InputToken.getPayload()).getAbsolutePath();
        } else {
            try {
                file = TempUtils.createTempFile((String)((Object)((Object)this)).getClass().getSimpleName(), (String)".png");
                fileStr = file.getAbsolutePath();
                BufferedImage img = ((AbstractImageContainer)this.m_InputToken.getPayload()).toBufferedImage();
                result = BufferedImageHelper.write((BufferedImage)img, (File)file);
            }
            catch (Exception e) {
                result = this.handleException("Failed to save image to temporary file!", e);
            }
        }
        if (result == null) {
            String[] files;
            LocalDirectoryLister lister = new LocalDirectoryLister();
            lister.setWatchDir(this.m_OutputBase.getParentFile().getAbsolutePath());
            lister.setRegExp(new BaseRegExp(this.m_OutputBase.getName() + ".*"));
            lister.setListFiles(true);
            lister.setListDirs(false);
            lister.setRecursive(false);
            for (String f : files = lister.list()) {
                FileUtils.delete((File)new PlaceholderFile(f));
            }
            String[] cmd = this.m_Configuration.getCommand(fileStr, this.m_OutputBase.getAbsolutePath(), this.m_Language, this.m_PageSegmentation, this.m_OutputHOCR);
            try {
                this.m_ProcessOutput = ProcessUtils.execute((String[])cmd);
                if (this.m_ProcessOutput.getExitCode() != 0) {
                    result = "tesseract exited with " + this.m_ProcessOutput.getExitCode() + "\ncmd: " + OptionUtils.joinOptions((String[])cmd) + "\nstderr:\n" + this.m_ProcessOutput.getStdErr();
                } else {
                    files = lister.list();
                    if (this.m_OutputText) {
                        StringBuilder content = new StringBuilder();
                        boolean first = true;
                        for (String f : files) {
                            if (!first) {
                                content.append(this.m_Separator);
                                first = false;
                            }
                            content.append(Utils.flatten((List)FileUtils.loadFromFile((File)new PlaceholderFile(f)), (String)"\n"));
                        }
                        this.m_OutputToken = new Token((Object)content.toString());
                    } else {
                        this.m_OutputToken = new Token((Object)files);
                    }
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to execute tesseract: " + OptionUtils.joinOptions((String[])cmd), e);
            }
            this.m_ProcessOutput = null;
            lister = null;
        }
        if (file != null && file.exists()) {
            file.delete();
        }
        return result;
    }

    public void stopExecution() {
        if (this.m_ProcessOutput != null) {
            this.m_ProcessOutput.destroy();
        }
        super.stopExecution();
    }
}

