/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseKeyValuePair;
import adams.core.option.OptionHandler;
import adams.data.report.Report;
import adams.flow.transformer.AbstractArrayProvider;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public class ViaAnnotationsToReports
extends AbstractArrayProvider {
    private static final long serialVersionUID = 6162307113533583549L;
    protected String m_DefaultLabel;
    protected BaseKeyValuePair[] m_LabelMapping;
    protected Map<String, String> m_Mappings;

    public String globalInfo() {
        return "Converts the JSON object passing through to Reports.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("default-label", "defaultLabel", (Object)"");
        this.m_OptionManager.add("label-mapping", "labelMapping", (Object)new BaseKeyValuePair[0]);
    }

    protected void reset() {
        super.reset();
        this.m_Mappings = null;
    }

    protected Class getItemClass() {
        return Report.class;
    }

    public String outputArrayTipText() {
        return "Whether to output the Reports as array or one-by-one.";
    }

    public void setDefaultLabel(String value) {
        this.m_DefaultLabel = value;
        this.reset();
    }

    public String getDefaultLabel() {
        return this.m_DefaultLabel;
    }

    public String defaultLabelTipText() {
        return "Replaces empty labels with provided label. No default label if empty.";
    }

    public void setLabelMapping(BaseKeyValuePair[] value) {
        this.m_LabelMapping = value;
        this.reset();
    }

    public BaseKeyValuePair[] getLabelMapping() {
        return this.m_LabelMapping;
    }

    public String labelMappingTipText() {
        return "Label mapping, in the form old=new\\n. No label mapping if empty.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"defaultLabel", (Object)this.m_DefaultLabel, (String)"default-label: ");
        result = result != null ? result + ", " : "";
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"labelMapping", (Object)this.m_LabelMapping, (String)"label-mapping: ");
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"outputArray", (boolean)this.m_OutputArray, (String)"output array"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    public Class[] accepts() {
        return new Class[]{JSONObject.class};
    }

    protected String doExecute() {
        String result = null;
        JSONObject json = (JSONObject)this.m_InputToken.getPayload(JSONObject.class);
        if (this.m_Mappings == null) {
            this.m_Mappings = new HashMap<String, String>();
            for (BaseKeyValuePair pair : this.m_LabelMapping) {
                this.m_Mappings.put(pair.getPairKey(), pair.getPairValue());
            }
        }
        try {
            JSONObject metadata = (JSONObject)json.get((Object)"_via_img_metadata");
            for (String key : metadata.keySet()) {
                JSONObject image = (JSONObject)metadata.get((Object)key);
                JSONArray regions = (JSONArray)image.get((Object)"regions");
                LocatedObjects objects = new LocatedObjects();
                for (int i = 0; i < regions.size(); ++i) {
                    LocatedObject object;
                    JSONObject region = (JSONObject)regions.get(i);
                    JSONObject shape = (JSONObject)region.get((Object)"shape_attributes");
                    JSONObject regionAtts = (JSONObject)region.get((Object)"region_attributes");
                    if (shape.containsKey((Object)"all_points_x")) {
                        JSONArray pointsX = (JSONArray)shape.get((Object)"all_points_x");
                        JSONArray pointsY = (JSONArray)shape.get((Object)"all_points_y");
                        int[] x = new int[pointsX.size()];
                        int[] y = new int[pointsY.size()];
                        for (int p = 0; p < pointsX.size(); ++p) {
                            x[p] = ((Number)pointsX.get(p)).intValue();
                            y[p] = ((Number)pointsY.get(p)).intValue();
                        }
                        Polygon polygon = new Polygon(x, y, x.length);
                        object = new LocatedObject(polygon);
                    } else {
                        object = new LocatedObject(shape.getAsNumber("x").intValue(), shape.getAsNumber("y").intValue(), shape.getAsNumber("width").intValue(), shape.getAsNumber("height").intValue());
                    }
                    String label = null;
                    if (regionAtts != null && regionAtts.get((Object)"name") != null) {
                        label = "" + regionAtts.get((Object)"name");
                    } else if (!this.m_DefaultLabel.isEmpty()) {
                        label = this.m_DefaultLabel;
                    }
                    if (this.m_Mappings.size() > 0 && label != null) {
                        label = this.m_Mappings.getOrDefault(label, label);
                    }
                    if (label != null) {
                        object.getMetaData().put("type", label);
                    }
                    objects.add(object);
                }
                Report report = objects.toReport("Object.");
                report.setStringValue("Filename", image.getAsString("filename"));
                this.m_Queue.add(report);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to parse VIA json object", e);
        }
        return result;
    }
}

