/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.draw;

import adams.data.image.BufferedImageContainer;
import adams.flow.transformer.draw.AbstractDrawObjectsFromReport;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;

public class ObjectLocationsFromReport
extends AbstractDrawObjectsFromReport {
    private static final long serialVersionUID = 6356419097401574024L;
    protected float m_StrokeThickness;
    protected boolean m_Filled;
    protected boolean m_PolygonBounds;

    public String globalInfo() {
        return "Displays the locations of objects in the image, using data from the attached report.\nSuffixes:\n.x\n.y\n.width\n.height\nOptionally, if type information is available per object, the locations can be displayed in distinct colors per type. The type itself can be displayed as well.\nIf polygon data should be available (.poly_x and .poly_y), then this takes precedence over the rectangle coordinates.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("stroke-thickness", "strokeThickness", (Object)Float.valueOf(1.0f), (Number)Float.valueOf(0.01f), null);
        this.m_OptionManager.add("filled", "filled", (Object)false);
        this.m_OptionManager.add("polygon-bounds", "polygonBounds", (Object)false);
    }

    public void setStrokeThickness(float value) {
        this.m_StrokeThickness = value;
        this.reset();
    }

    public float getStrokeThickness() {
        return this.m_StrokeThickness;
    }

    public String strokeThicknessTipText() {
        return "The thickness of the stroke.";
    }

    public void setFilled(boolean value) {
        this.m_Filled = value;
        this.reset();
    }

    public boolean getFilled() {
        return this.m_Filled;
    }

    public String filledTipText() {
        return "If enabled, the shape is drawn filled.";
    }

    public void setPolygonBounds(boolean value) {
        this.m_PolygonBounds = value;
        this.reset();
    }

    public boolean getPolygonBounds() {
        return this.m_PolygonBounds;
    }

    public String polygonBoundsTipText() {
        return "If enabled, the polygon bounds are drawn as well.";
    }

    protected float getStrokeWidth(Graphics g, float defValue) {
        Graphics2D g2d;
        if (g instanceof Graphics2D && (g2d = (Graphics2D)g).getStroke() instanceof BasicStroke) {
            return ((BasicStroke)g2d.getStroke()).getLineWidth();
        }
        return defValue;
    }

    protected void applyStroke(Graphics g, float stroke) {
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(new BasicStroke(stroke));
        }
    }

    @Override
    protected String doDraw(BufferedImageContainer image, List<Polygon> locations) {
        Graphics g = ((BufferedImage)image.getImage()).getGraphics();
        float width = this.getStrokeWidth(g, 1.0f);
        this.applyStroke(g, this.m_StrokeThickness);
        g.setColor(this.getColor());
        g.setFont(this.getLabelFont());
        for (Polygon poly : locations) {
            String label;
            if (this.getUseColorsPerType() && this.m_Overlays.hasColor(poly)) {
                g.setColor(this.m_Overlays.getColor(poly));
            }
            if (this.m_Filled) {
                g.fillPolygon(poly);
            } else {
                g.drawPolygon(poly);
            }
            Rectangle rect = null;
            if (this.m_PolygonBounds) {
                rect = poly.getBounds();
                g.drawRect(rect.x, rect.y, rect.width, rect.height);
            }
            if (!this.m_Overlays.hasLabel(poly) || (label = this.m_Overlays.getLabel(poly)) == null) continue;
            if (rect == null) {
                rect = poly.getBounds();
            }
            this.m_Overlays.drawString(g, rect, label);
        }
        this.applyStroke(g, width);
        return null;
    }
}

