/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.draw;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.BufferedImageContainer;
import adams.flow.transformer.draw.AbstractColorDrawOperation;
import adams.gui.core.ColorHelper;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class Pixel
extends AbstractColorDrawOperation {
    private static final long serialVersionUID = -337973956383988281L;
    protected int m_X;
    protected int m_Y;
    protected PixelValueType m_Type;
    protected int m_RGBA;

    public String globalInfo() {
        return "Draws a pixel with the specified color at the specified location.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x", "X", (Object)1, (Number)1, null);
        this.m_OptionManager.add("y", "Y", (Object)1, (Number)1, null);
        this.m_OptionManager.add("type", "type", (Object)PixelValueType.RGBA);
        this.m_OptionManager.add("rgba", "RGBA", (Object)0, (Number)0, null);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"X", (Object)this.m_X, (String)"X: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"Y", (Object)this.m_Y, (String)", Y: ");
        if (QuickInfoHelper.hasVariable((OptionHandler)this, (String)"type")) {
            result = result + ", " + QuickInfoHelper.getVariable((OptionHandler)this, (String)"type");
        } else {
            switch (this.m_Type) {
                case RGBA: {
                    result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"RGBA", (Object)this.m_RGBA, (String)", RGBA: ");
                    break;
                }
                case COLOR: {
                    result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"color", (Object)ColorHelper.toHex((Color)this.m_Color), (String)", Color: ");
                }
            }
        }
        return result;
    }

    public void setX(int value) {
        if (value > 0) {
            this.m_X = value;
            this.reset();
        } else {
            this.getLogger().severe("X must be >0, provided: " + value);
        }
    }

    public int getX() {
        return this.m_X;
    }

    public String XTipText() {
        return "The X position of the pixel (1-based).";
    }

    public void setY(int value) {
        if (value > 0) {
            this.m_Y = value;
            this.reset();
        } else {
            this.getLogger().severe("Y must be >0, provided: " + value);
        }
    }

    public int getY() {
        return this.m_Y;
    }

    public String YTipText() {
        return "The Y position of the pixel (1-based).";
    }

    public void setType(PixelValueType value) {
        this.m_Type = value;
        this.reset();
    }

    public PixelValueType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of value to use for the pixel.";
    }

    public void setRGBA(int value) {
        if (value >= 0) {
            this.m_RGBA = value;
            this.reset();
        } else {
            this.getLogger().severe("RGBA must be >=0, provided: " + value);
        }
    }

    public int getRGBA() {
        return this.m_RGBA;
    }

    public String RGBATipText() {
        return "The RGBA value (>= 0).";
    }

    @Override
    protected String check(BufferedImageContainer image) {
        String result = super.check(image);
        if (result == null) {
            if (this.m_X > image.getWidth()) {
                result = "X is larger than image width: " + this.m_X + " > " + image.getWidth();
            } else if (this.m_Y > image.getHeight()) {
                result = "Y is larger than image height: " + this.m_Y + " > " + image.getHeight();
            }
        }
        return result;
    }

    @Override
    protected String doDraw(BufferedImageContainer image) {
        String result = null;
        switch (this.m_Type) {
            case RGBA: {
                ((BufferedImage)image.getImage()).setRGB(this.m_X - 1, this.m_Y - 1, this.m_RGBA);
                break;
            }
            case COLOR: {
                ((BufferedImage)image.getImage()).setRGB(this.m_X - 1, this.m_Y - 1, this.m_Color.getRGB());
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled pixel value type: " + (Object)((Object)this.m_Type));
            }
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("X=" + this.m_X + ", Y=" + this.m_Y + " -> " + this.m_RGBA);
        }
        return result;
    }

    public static enum PixelValueType {
        RGBA,
        COLOR;

    }
}

