/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.exiftagoperation;

import adams.core.License;
import adams.core.MessageCollection;
import adams.core.Utils;
import adams.core.annotation.MixedCopyright;
import adams.core.io.PlaceholderFile;
import adams.flow.transformer.exiftagoperation.AbstractApacheCommonsExifTagOperation;
import adams.flow.transformer.exiftagoperation.ExifTagExistsOperation;
import java.io.File;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoAscii;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoByte;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoDouble;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoFloat;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoRational;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoShort;

@MixedCopyright(author="yurko - https://stackoverflow.com/users/418516/yurko", url="https://stackoverflow.com/a/36873897/4698227", license=License.CC_BY_SA_3, note="general usage of Apache Commons Imaging for EXIF operations")
public class ApacheCommonsExifTagExists
extends AbstractApacheCommonsExifTagOperation<Object, Boolean>
implements ExifTagExistsOperation<Object> {
    private static final long serialVersionUID = -4257460091938302125L;

    public String globalInfo() {
        return "Checks whether the specified tag is present in the the file.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Boolean.class};
    }

    @Override
    protected String check(Object input) {
        String result = super.check(input);
        if (!(result != null || this.m_Tag.getTagInfo() instanceof TagInfoAscii || this.m_Tag.getTagInfo() instanceof TagInfoByte || this.m_Tag.getTagInfo() instanceof TagInfoShort || this.m_Tag.getTagInfo() instanceof TagInfoDouble || this.m_Tag.getTagInfo() instanceof TagInfoFloat || this.m_Tag.getTagInfo() instanceof TagInfoRational)) {
            result = "Unhandled tag info type: " + Utils.classToString((Object)this.m_Tag.getTagInfo());
        }
        return result;
    }

    @Override
    protected Boolean doProcess(Object input, MessageCollection errors) {
        Boolean result = false;
        File inputFile = input instanceof String ? new PlaceholderFile((String)input).getAbsoluteFile() : ((File)input).getAbsoluteFile();
        try {
            JpegImageMetadata meta = (JpegImageMetadata)Imaging.getMetadata((File)inputFile);
            if (meta != null) {
                TiffImageMetadata exif = meta.getExif();
                if (exif != null) {
                    result = exif.getFieldValue(this.m_Tag.getTagInfo()) != null;
                } else {
                    errors.add("No EXIF meta-data available: " + input);
                }
            } else {
                errors.add("No meta-data available: " + input);
            }
        }
        catch (Exception e) {
            errors.add("Failed to read EXIF tag " + (Object)((Object)this.m_Tag) + " from: " + input, (Throwable)e);
        }
        return result;
    }
}

