/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.exiftagoperation;

import adams.core.License;
import adams.core.MessageCollection;
import adams.core.Utils;
import adams.core.annotation.MixedCopyright;
import adams.core.io.PlaceholderFile;
import adams.flow.core.Unknown;
import adams.flow.transformer.exiftagoperation.AbstractApacheCommonsExifTagOperation;
import adams.flow.transformer.exiftagoperation.ExifTagReadOperation;
import java.io.File;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoAscii;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoByte;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoDouble;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoFloat;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoRational;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoShort;

@MixedCopyright(author="yurko - https://stackoverflow.com/users/418516/yurko", url="https://stackoverflow.com/a/36873897/4698227", license=License.CC_BY_SA_3, note="general usage of Apache Commons Imaging for EXIF operations")
public class ApacheCommonsExifTagRead
extends AbstractApacheCommonsExifTagOperation<Object, Object>
implements ExifTagReadOperation<Object, Object> {
    private static final long serialVersionUID = -4257460091938302125L;

    public String globalInfo() {
        return "Reads the specified tag from the file and forwards the information.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    @Override
    public Class[] generates() {
        if (this.m_Tag.getTagInfo() instanceof TagInfoAscii) {
            return new Class[]{String.class};
        }
        if (this.m_Tag.getTagInfo() instanceof TagInfoByte) {
            return new Class[]{Byte.class};
        }
        if (this.m_Tag.getTagInfo() instanceof TagInfoShort) {
            return new Class[]{Short.class};
        }
        if (this.m_Tag.getTagInfo() instanceof TagInfoDouble) {
            return new Class[]{Double.class};
        }
        if (this.m_Tag.getTagInfo() instanceof TagInfoFloat) {
            return new Class[]{Float.class};
        }
        if (this.m_Tag.getTagInfo() instanceof TagInfoRational) {
            return new Class[]{Double.class};
        }
        return new Class[]{Unknown.class};
    }

    @Override
    protected String check(Object input) {
        String result = super.check(input);
        if (!(result != null || this.m_Tag.getTagInfo() instanceof TagInfoAscii || this.m_Tag.getTagInfo() instanceof TagInfoByte || this.m_Tag.getTagInfo() instanceof TagInfoShort || this.m_Tag.getTagInfo() instanceof TagInfoDouble || this.m_Tag.getTagInfo() instanceof TagInfoFloat || this.m_Tag.getTagInfo() instanceof TagInfoRational)) {
            result = "Unhandled tag info type: " + Utils.classToString((Object)this.m_Tag.getTagInfo());
        }
        return result;
    }

    @Override
    protected Object doProcess(Object input, MessageCollection errors) {
        Object result = null;
        File inputFile = input instanceof String ? new PlaceholderFile((String)input).getAbsoluteFile() : ((File)input).getAbsoluteFile();
        try {
            JpegImageMetadata meta = (JpegImageMetadata)Imaging.getMetadata((File)inputFile);
            if (meta != null) {
                TiffImageMetadata exif = meta.getExif();
                if (exif != null) {
                    result = exif.getFieldValue(this.m_Tag.getTagInfo());
                } else {
                    errors.add("No EXIF meta-data available: " + input);
                }
            } else {
                errors.add("No meta-data available: " + input);
            }
        }
        catch (Exception e) {
            errors.add("Failed to read EXIF tag " + (Object)((Object)this.m_Tag) + " from: " + input, (Throwable)e);
        }
        return result;
    }
}

