/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.locateobjects;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.ImageAnchor;
import adams.data.image.ImageAnchorHelper;
import adams.flow.transformer.locateobjects.AbstractMetaObjectLocator;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;

public class ChangeCanvasSize
extends AbstractMetaObjectLocator {
    private static final long serialVersionUID = 7548064590836834398L;
    protected int m_CanvasWidth;
    protected int m_CanvasHeight;
    protected ImageAnchor m_Anchor;
    protected Color m_Background;

    public String globalInfo() {
        return "Places the located objects obtained from the base locator on a canvas of specified size at the specified position.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("canvas-width", "canvasWidth", (Object)100, (Number)1, null);
        this.m_OptionManager.add("canvas-height", "canvasHeight", (Object)100, (Number)1, null);
        this.m_OptionManager.add("anchor", "anchor", (Object)ImageAnchor.TOP_LEFT);
        this.m_OptionManager.add("background", "background", (Object)Color.WHITE);
    }

    @Override
    public void setCanvasWidth(int value) {
        if (value > 0) {
            this.m_CanvasWidth = value;
            this.reset();
        } else {
            this.getLogger().severe("Canvas width has to be >0, provided: " + value);
        }
    }

    @Override
    public int getCanvasWidth() {
        return this.m_CanvasWidth;
    }

    @Override
    public String canvasWidthTipText() {
        return "The width of the canvas in pixels.";
    }

    @Override
    public void setCanvasHeight(int value) {
        if (value > 0) {
            this.m_CanvasHeight = value;
            this.reset();
        } else {
            this.getLogger().severe("Canvas height has to be >0, provided: " + value);
        }
    }

    @Override
    public int getCanvasHeight() {
        return this.m_CanvasHeight;
    }

    @Override
    public String canvasHeightTipText() {
        return "The height of the canvas in pixels.";
    }

    public void setAnchor(ImageAnchor value) {
        this.m_Anchor = value;
        this.reset();
    }

    public ImageAnchor getAnchor() {
        return this.m_Anchor;
    }

    public String anchorTipText() {
        return "Defines where to anchor the position on the canvas.";
    }

    public void setBackground(Color value) {
        this.m_Background = value;
        this.reset();
    }

    public Color getBackground() {
        return this.m_Background;
    }

    public String backgroundTipText() {
        return "The background color to use.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"canvasWidth", (Object)this.m_CanvasWidth, (String)"width: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"canvasHeight", (Object)this.m_CanvasHeight, (String)", height: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"anchor", (Object)((Object)this.m_Anchor), (String)", anchor: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"background", (Object)this.m_Background, (String)", bg: ");
        return result;
    }

    @Override
    protected LocatedObjects doLocate(BufferedImage image, boolean annotateOnly) {
        LocatedObjects result = new LocatedObjects();
        LocatedObjects base = this.m_Locator.locate(image);
        for (LocatedObject obj : base) {
            Point[] corners = ImageAnchorHelper.calculateCorners(this.m_CanvasWidth, this.m_CanvasHeight, this.m_Anchor, 0.0, 0.0, obj.getImage().getWidth(), obj.getImage().getHeight(), false);
            int leftNew = (int)corners[0].getX();
            int topNew = (int)corners[0].getY();
            int heightOrig = obj.getImage().getHeight();
            int widthOrig = obj.getImage().getWidth();
            BufferedImage modified = new BufferedImage(this.m_CanvasWidth, this.m_CanvasHeight, 2);
            Graphics2D g = modified.createGraphics();
            g.setColor(this.m_Background);
            g.fillRect(0, 0, this.m_CanvasWidth, this.m_CanvasHeight);
            g.dispose();
            for (int y = 0; y < heightOrig; ++y) {
                int yNew = topNew + y;
                if (yNew < 0 || yNew >= this.m_CanvasHeight) continue;
                for (int x = 0; x < widthOrig; ++x) {
                    int xNew = leftNew + x;
                    if (xNew < 0 || xNew >= this.m_CanvasWidth) continue;
                    modified.setRGB(xNew, yNew, obj.getImage().getRGB(x, y));
                }
            }
            result.add(new LocatedObject(annotateOnly ? null : modified, obj.getX(), obj.getY(), obj.getWidth(), obj.getHeight()));
        }
        return result;
    }
}

