/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.io.PlaceholderFile;
import adams.data.featureconverter.AbstractFeatureConverter;
import adams.data.featureconverter.SpreadSheet;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.features.ColorCounts;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.ApacheCommonsImageReader;
import adams.data.spreadsheet.Row;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.SearchPanel;
import adams.gui.core.SpreadSheetTable;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.NoPreviewAvailablePanel;
import adams.gui.tools.previewbrowser.PreviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ColorDistributionHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = -3962259305718630395L;
    protected AbstractImageReader m_Reader;

    public String globalInfo() {
        return "Displays the color distribution for images.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", (Object)new ApacheCommonsImageReader());
    }

    public void setReader(AbstractImageReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public AbstractImageReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The reader to use for loading the images.";
    }

    public String[] getExtensions() {
        return this.m_Reader.getFormatExtensions();
    }

    protected PreviewPanel createPreview(File file) {
        try {
            AbstractImageContainer cont = this.m_Reader.read(new PlaceholderFile(file));
            if (cont == null) {
                return new NoPreviewAvailablePanel();
            }
            BufferedImageContainer bcont = new BufferedImageContainer();
            bcont.setImage((Object)cont.toBufferedImage());
            ColorCounts counts = new ColorCounts();
            counts.setConverter((AbstractFeatureConverter)new SpreadSheet());
            Object[] rows = counts.generate(bcont);
            adams.data.spreadsheet.SpreadSheet sheet = null;
            for (Object row : rows) {
                Row srow = (Row)row;
                if (sheet == null) {
                    sheet = srow.getOwner().getHeader();
                }
                sheet.addRow().assign(srow);
            }
            counts.cleanUp();
            if (sheet == null) {
                return new NoPreviewAvailablePanel();
            }
            JPanel panel = new JPanel(new BorderLayout(5, 5));
            SpreadSheetTable table = new SpreadSheetTable(sheet);
            panel.add((Component)new BaseScrollPane((Component)table));
            SearchPanel search = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
            search.addSearchListener(e -> table.search(e.getParameters().getSearchString(), e.getParameters().isRegExp()));
            panel.add((Component)search, "South");
            return new PreviewPanel((JComponent)panel, (JComponent)table);
        }
        catch (Exception e2) {
            return new NoPreviewAvailablePanel();
        }
    }
}

