/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.core.annotation.DeprecatedClass;
import adams.core.base.BaseRegExp;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.DetectronAnnotationsReportReader;
import adams.data.io.input.JAIImageReader;
import adams.data.objectfinder.ByMetaDataStringValue;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.core.Fonts;
import adams.gui.event.ImagePanelLeftClickListener;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.CocoAnnotationsHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.ObjectLocationsOverlayFromReport;
import adams.gui.visualization.image.leftclick.ViewObjects;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;

@DeprecatedClass(useInstead={CocoAnnotationsHandler.class})
public class DetectronAnnotationsHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = -1671414346233382229L;
    protected String m_Prefix;
    protected Color m_Color;
    protected boolean m_UseColorsPerType;
    protected ColorProvider m_TypeColorProvider;
    protected String m_TypeSuffix;
    protected BaseRegExp m_TypeRegExp;
    protected String m_LabelFormat;
    protected Font m_LabelFont;

    public String globalInfo() {
        return "Displays the following image types with an overlay for the objects stored in the Detectron annotations JSON file (using object prefix 'Object.'): " + Utils.arrayToString((Object)this.getExtensions());
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
        this.m_OptionManager.add("color", "color", (Object)Color.RED);
        this.m_OptionManager.add("use-colors-per-type", "useColorsPerType", (Object)true);
        this.m_OptionManager.add("type-color-provider", "typeColorProvider", (Object)new DefaultColorProvider());
        this.m_OptionManager.add("type-suffix", "typeSuffix", (Object)".type");
        this.m_OptionManager.add("type-regexp", "typeRegExp", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("label-format", "labelFormat", (Object)"#. $");
        this.m_OptionManager.add("label-font", "labelFont", (Object)Fonts.getSansFont((int)14));
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix of fields in the report to identify as object location, eg 'Object.'.";
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color to use for the objects.";
    }

    public void setUseColorsPerType(boolean value) {
        this.m_UseColorsPerType = value;
        this.reset();
    }

    public boolean getUseColorsPerType() {
        return this.m_UseColorsPerType;
    }

    public String useColorsPerTypeTipText() {
        return "If enabled, individual colors per type are used.";
    }

    public void setTypeColorProvider(ColorProvider value) {
        this.m_TypeColorProvider = value;
        this.reset();
    }

    public ColorProvider getTypeColorProvider() {
        return this.m_TypeColorProvider;
    }

    public String typeColorProviderTipText() {
        return "The color provider to use for the various types.";
    }

    public void setTypeSuffix(String value) {
        this.m_TypeSuffix = value;
        this.reset();
    }

    public String getTypeSuffix() {
        return this.m_TypeSuffix;
    }

    public String typeSuffixTipText() {
        return "The suffix of fields in the report to identify the type.";
    }

    public void setTypeRegExp(BaseRegExp value) {
        this.m_TypeRegExp = value;
        this.reset();
    }

    public BaseRegExp getTypeRegExp() {
        return this.m_TypeRegExp;
    }

    public String typeRegExpTipText() {
        return "The regular expression that the types must match in order to get drawn (eg only plotting a subset).";
    }

    public void setLabelFormat(String value) {
        this.m_LabelFormat = value;
        this.reset();
    }

    public String getLabelFormat() {
        return this.m_LabelFormat;
    }

    public String labelFormatTipText() {
        return "The label format string to use for the rectangles; '#' for index, '@' for type and '$' for short type (type suffix must be defined for '@' and '$'); for instance: '# @'.";
    }

    public void setLabelFont(Font value) {
        this.m_LabelFont = value;
        this.reset();
    }

    public Font getLabelFont() {
        return this.m_LabelFont;
    }

    public String labelFontTipText() {
        return "The font to use for the labels.";
    }

    public String[] getExtensions() {
        return new JAIImageReader().getFormatExtensions();
    }

    protected PreviewPanel createPreview(File file) {
        ImagePanel panel = new ImagePanel();
        Report report = null;
        File reportFile = new File(file.getParent() + "/annotations.json");
        boolean found = false;
        if (reportFile.exists() && reportFile.isFile()) {
            DetectronAnnotationsReportReader reportReader = new DetectronAnnotationsReportReader();
            reportReader.setLabelKey("type");
            reportReader.setInput(new PlaceholderFile(reportFile));
            List reports = reportReader.read();
            for (int i = 0; i < reports.size(); ++i) {
                report = (Report)reports.get(i);
                ByMetaDataStringValue filter = new ByMetaDataStringValue();
                filter.setKey("filename");
                filter.setRegExp(new BaseRegExp(file.getName()));
                LocatedObjects lobjs = filter.findObjects(report);
                if (lobjs.size() <= 0) continue;
                report = lobjs.toReport("Object.");
                found = true;
                break;
            }
            if (found) {
                ObjectLocationsOverlayFromReport overlay = new ObjectLocationsOverlayFromReport();
                overlay.setPrefix("Object.");
                overlay.setColor(this.m_Color);
                overlay.setUseColorsPerType(this.m_UseColorsPerType);
                overlay.setTypeColorProvider((ColorProvider)this.m_TypeColorProvider.shallowCopy());
                overlay.setTypeSuffix(this.m_TypeSuffix);
                overlay.setTypeRegExp((BaseRegExp)this.m_TypeRegExp.getClone());
                overlay.setLabelFormat(this.m_LabelFormat);
                overlay.setLabelFont(this.m_LabelFont);
                panel.addImageOverlay((ImageOverlay)overlay);
            }
        }
        panel.load(file, (AbstractImageReader)new JAIImageReader(), -1.0);
        panel.setAdditionalProperties(report);
        panel.addLeftClickListener((ImagePanelLeftClickListener)new ViewObjects());
        return new PreviewPanel((JComponent)panel, (JComponent)panel.getPaintPanel());
    }
}

