/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.JAIImageReader;
import adams.data.io.input.ObjectLocationsSpreadSheetReader;
import adams.data.objectfinder.AllFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.data.objectoverlap.AreaRatio;
import adams.data.objectoverlap.ObjectOverlap;
import adams.data.overlappingobjectremoval.AbstractOverlappingObjectRemoval;
import adams.data.overlappingobjectremoval.OverlappingObjectRemoval;
import adams.data.overlappingobjectremoval.PassThrough;
import adams.data.report.Report;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.chooser.DirectoryChooserPanel;
import adams.gui.core.BaseCheckBox;
import adams.gui.core.BasePanel;
import adams.gui.core.Fonts;
import adams.gui.event.ImagePanelLeftClickListener;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.ObjectLocationsOverlayFromReport;
import adams.gui.visualization.image.leftclick.ViewObjects;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ObjectLocationsFromSpreadSheet
extends AbstractContentHandler {
    private static final long serialVersionUID = -3962259305718630395L;
    protected ObjectLocationsSpreadSheetReader m_Reader;
    protected String m_AlternativeFileSuffix;
    protected Color m_Color;
    protected boolean m_UseColorsPerType;
    protected ColorProvider m_TypeColorProvider;
    protected String m_TypeSuffix;
    protected BaseRegExp m_TypeRegExp;
    protected String m_LabelFormat;
    protected Font m_LabelFont;
    protected ObjectFinder m_Finder;
    protected ObjectOverlap m_OverlapDetection;
    protected OverlappingObjectRemoval m_OverlapRemoval;
    protected boolean m_UseAlternativeLocation;
    protected PlaceholderDirectory m_AlternativeLocation;

    public String globalInfo() {
        return "Displays the following image types with an overlay for the objects stored in the spreadsheet with the same name (using the spreadsheet reader's default extension) or with the specified alternative file suffix to the name (eg '-rois'): " + Utils.arrayToString((Object)this.getExtensions());
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", (Object)this.getDefaultReader());
        this.m_OptionManager.add("alternative-file-suffix", "alternativeFileSuffix", (Object)"-rois");
        this.m_OptionManager.add("color", "color", (Object)Color.RED);
        this.m_OptionManager.add("use-colors-per-type", "useColorsPerType", (Object)true);
        this.m_OptionManager.add("type-color-provider", "typeColorProvider", (Object)new DefaultColorProvider());
        this.m_OptionManager.add("type-suffix", "typeSuffix", (Object)".type");
        this.m_OptionManager.add("type-regexp", "typeRegExp", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("label-format", "labelFormat", (Object)"#. $");
        this.m_OptionManager.add("label-font", "labelFont", (Object)Fonts.getSansFont((int)14));
        this.m_OptionManager.add("finder", "finder", (Object)new AllFinder());
        this.m_OptionManager.add("overlap-detection", "overlapDetection", (Object)new AreaRatio());
        this.m_OptionManager.add("overlap-removal", "overlapRemoval", (Object)new PassThrough());
        this.m_OptionManager.add("use-alternative-location", "useAlternativeLocation", (Object)false);
        this.m_OptionManager.add("alternative-location", "alternativeLocation", (Object)new PlaceholderDirectory());
    }

    protected ObjectLocationsSpreadSheetReader getDefaultReader() {
        ObjectLocationsSpreadSheetReader result = new ObjectLocationsSpreadSheetReader();
        result.setColLeft(new SpreadSheetColumnIndex("x0"));
        result.setColTop(new SpreadSheetColumnIndex("y0"));
        result.setColRight(new SpreadSheetColumnIndex("x1"));
        result.setColBottom(new SpreadSheetColumnIndex("y1"));
        result.setColType(new SpreadSheetColumnIndex("label_str"));
        return result;
    }

    public void setReader(ObjectLocationsSpreadSheetReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public ObjectLocationsSpreadSheetReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The reader setup to use for reading the object locations from the spreadsheet.";
    }

    public void setAlternativeFileSuffix(String value) {
        this.m_AlternativeFileSuffix = value;
        this.reset();
    }

    public String getAlternativeFileSuffix() {
        return this.m_AlternativeFileSuffix;
    }

    public String alternativeFileSuffixTipText() {
        return "The alternative file suffix to use for locating the associated spreadsheet (eg '-rois').";
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color to use for the objects.";
    }

    public void setUseColorsPerType(boolean value) {
        this.m_UseColorsPerType = value;
        this.reset();
    }

    public boolean getUseColorsPerType() {
        return this.m_UseColorsPerType;
    }

    public String useColorsPerTypeTipText() {
        return "If enabled, individual colors per type are used.";
    }

    public void setTypeColorProvider(ColorProvider value) {
        this.m_TypeColorProvider = value;
        this.reset();
    }

    public ColorProvider getTypeColorProvider() {
        return this.m_TypeColorProvider;
    }

    public String typeColorProviderTipText() {
        return "The color provider to use for the various types.";
    }

    public void setTypeSuffix(String value) {
        this.m_TypeSuffix = value;
        this.reset();
    }

    public String getTypeSuffix() {
        return this.m_TypeSuffix;
    }

    public String typeSuffixTipText() {
        return "The suffix of fields in the report to identify the type.";
    }

    public void setTypeRegExp(BaseRegExp value) {
        this.m_TypeRegExp = value;
        this.reset();
    }

    public BaseRegExp getTypeRegExp() {
        return this.m_TypeRegExp;
    }

    public String typeRegExpTipText() {
        return "The regular expression that the types must match in order to get drawn (eg only plotting a subset).";
    }

    public void setLabelFormat(String value) {
        this.m_LabelFormat = value;
        this.reset();
    }

    public String getLabelFormat() {
        return this.m_LabelFormat;
    }

    public String labelFormatTipText() {
        return "The label format string to use for the rectangles; '#' for index, '@' for type and '$' for short type (type suffix must be defined for '@' and '$'); for instance: '# @'.";
    }

    public void setLabelFont(Font value) {
        this.m_LabelFont = value;
        this.reset();
    }

    public Font getLabelFont() {
        return this.m_LabelFont;
    }

    public String labelFontTipText() {
        return "The font to use for the labels.";
    }

    public void setFinder(ObjectFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public ObjectFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The object finder to use.";
    }

    public void setOverlapDetection(ObjectOverlap value) {
        this.m_OverlapDetection = value;
        this.reset();
    }

    public ObjectOverlap getOverlapDetection() {
        return this.m_OverlapDetection;
    }

    public String overlapDetectionTipText() {
        return "The algorithm to use for determining the overlapping objects.";
    }

    public void setOverlapRemoval(OverlappingObjectRemoval value) {
        this.m_OverlapRemoval = value;
        this.reset();
    }

    public OverlappingObjectRemoval getOverlapRemoval() {
        return this.m_OverlapRemoval;
    }

    public String overlapRemovalTipText() {
        return "The algorithm to use for removing the overlapping objects.";
    }

    public void setUseAlternativeLocation(boolean value) {
        this.m_UseAlternativeLocation = value;
        this.reset();
    }

    public boolean getUseAlternativeLocation() {
        return this.m_UseAlternativeLocation;
    }

    public String useAlternativeLocationTipText() {
        return "If enabled, the alternative location is used to locate the associated report rather than the directory with the image.";
    }

    public void setAlternativeLocation(PlaceholderDirectory value) {
        this.m_AlternativeLocation = value;
        this.reset();
    }

    public PlaceholderDirectory getAlternativeLocation() {
        return this.m_AlternativeLocation;
    }

    public String alternativeLocationTipText() {
        return "The alternative location to use look for associated reports.";
    }

    public String[] getExtensions() {
        return new JAIImageReader().getFormatExtensions();
    }

    protected Report filterReport(Report report) {
        Report result;
        if (this.m_Finder instanceof AllFinder && this.m_OverlapRemoval instanceof PassThrough) {
            return report;
        }
        if (this.m_OverlapRemoval instanceof PassThrough) {
            LocatedObjects objs = this.m_Finder.findObjects(report);
            result = report.getClone();
            result.removeValuesStartingWith(this.m_Finder.getPrefix());
            result.mergeWith(objs.toReport(this.m_Finder.getPrefix()));
        } else {
            try {
                result = AbstractOverlappingObjectRemoval.remove(report, report, this.m_Finder, this.m_OverlapDetection, this.m_OverlapRemoval);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to remove objects!", (Throwable)e);
                result = report;
            }
        }
        return result;
    }

    protected Report loadReport(CombinedPanel panel, File file) {
        Report result = null;
        File baseFile = panel.getUseAlternativeLocation() ? new PlaceholderFile(panel.getAlternativeLocation().getAbsolutePath() + File.separator + file.getName()) : file;
        File locFile = FileUtils.replaceExtension((File)baseFile, (String)("." + this.m_Reader.getReader().getDefaultFormatExtension()));
        File locFile2 = FileUtils.replaceExtension((File)baseFile, (String)(this.m_AlternativeFileSuffix + "." + this.m_Reader.getReader().getDefaultFormatExtension()));
        if (locFile2.exists() && locFile2.isFile()) {
            locFile = locFile2;
        }
        if (locFile.exists() && locFile.isFile()) {
            this.m_Reader.setInput(new PlaceholderFile(locFile));
            List reports = this.m_Reader.read();
            if (reports.size() > 0) {
                result = this.filterReport((Report)reports.get(0));
            }
        }
        return result;
    }

    protected PreviewPanel createPreview(File file) {
        CombinedPanel panel = new CombinedPanel();
        panel.setAlternativeLocation((File)this.m_AlternativeLocation);
        panel.setUseAlternativeLocation(this.m_UseAlternativeLocation);
        Report report = this.loadReport(panel, file);
        panel.getImagePanel().load(file, (AbstractImageReader)new JAIImageReader(), -1.0);
        panel.getImagePanel().setAdditionalProperties(report);
        return new PreviewPanel((JComponent)((Object)panel), (JComponent)panel.getImagePanel().getPaintPanel());
    }

    public PreviewPanel reusePreview(File file, PreviewPanel previewPanel) {
        CombinedPanel panel = (CombinedPanel)((Object)previewPanel.getComponent());
        Report report = this.loadReport(panel, file);
        panel.getImagePanel().load(file, (AbstractImageReader)new JAIImageReader(), panel.getImagePanel().getScale());
        panel.getImagePanel().setAdditionalProperties(report);
        return previewPanel;
    }

    public class CombinedPanel
    extends BasePanel {
        private static final long serialVersionUID = 236378741683380463L;
        protected ImagePanel m_PanelImage;
        protected BaseCheckBox m_CheckBoxAlternative;
        protected DirectoryChooserPanel m_ChooserAlternative;

        protected void initGUI() {
            super.initGUI();
            this.setLayout(new BorderLayout());
            this.m_PanelImage = new ImagePanel();
            ObjectLocationsOverlayFromReport overlay = new ObjectLocationsOverlayFromReport();
            overlay.setPrefix(ObjectLocationsFromSpreadSheet.this.m_Reader.getPrefix());
            overlay.setColor(ObjectLocationsFromSpreadSheet.this.m_Color);
            overlay.setUseColorsPerType(ObjectLocationsFromSpreadSheet.this.m_UseColorsPerType);
            overlay.setTypeColorProvider((ColorProvider)ObjectLocationsFromSpreadSheet.this.m_TypeColorProvider.shallowCopy());
            overlay.setTypeSuffix(ObjectLocationsFromSpreadSheet.this.m_TypeSuffix);
            overlay.setTypeRegExp((BaseRegExp)ObjectLocationsFromSpreadSheet.this.m_TypeRegExp.getClone());
            overlay.setLabelFormat(ObjectLocationsFromSpreadSheet.this.m_LabelFormat);
            overlay.setLabelFont(ObjectLocationsFromSpreadSheet.this.m_LabelFont);
            this.m_PanelImage.addImageOverlay((ImageOverlay)overlay);
            this.m_PanelImage.addLeftClickListener((ImagePanelLeftClickListener)new ViewObjects());
            this.add((Component)this.m_PanelImage, "Center");
            JPanel panelBottom = new JPanel(new FlowLayout(0));
            this.add(panelBottom, "South");
            this.m_CheckBoxAlternative = new BaseCheckBox("Alternative spreadsheet location");
            this.m_CheckBoxAlternative.addActionListener(e -> this.toggleAlternative());
            panelBottom.add((Component)this.m_CheckBoxAlternative);
            this.m_ChooserAlternative = new DirectoryChooserPanel();
            this.m_ChooserAlternative.setEnabled(false);
            this.m_ChooserAlternative.addChangeListener(e -> this.updateReport());
            panelBottom.add((Component)this.m_ChooserAlternative);
        }

        protected void updateReport() {
            if (this.getImagePanel().getCurrentFile() != null) {
                this.getImagePanel().setAdditionalProperties(ObjectLocationsFromSpreadSheet.this.loadReport(this, this.getImagePanel().getCurrentFile()));
            }
        }

        protected void toggleAlternative() {
            this.m_ChooserAlternative.setEnabled(this.m_CheckBoxAlternative.isSelected());
            this.updateReport();
        }

        public void setUseAlternativeLocation(boolean value) {
            this.m_CheckBoxAlternative.setSelected(value);
            this.m_ChooserAlternative.setEnabled(value);
            this.updateReport();
        }

        public boolean getUseAlternativeLocation() {
            return this.m_CheckBoxAlternative.isSelected();
        }

        public void setAlternativeLocation(File value) {
            this.m_ChooserAlternative.setCurrent(value);
            this.updateReport();
        }

        public File getAlternativeLocation() {
            return (File)this.m_ChooserAlternative.getCurrent();
        }

        public ImagePanel getImagePanel() {
            return this.m_PanelImage;
        }
    }
}

