/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.JAIImageReader;
import adams.data.io.input.ViaAnnotationsReportReader;
import adams.data.objectfinder.ByMetaDataStringValue;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.event.ImagePanelLeftClickListener;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.ObjectLocationsOverlayFromReport;
import adams.gui.visualization.image.leftclick.ViewObjects;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;

public class ViaAnnotationsHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = -1671414346233382229L;

    public String globalInfo() {
        return "Displays the following image types with an overlay for the objects stored in the JSON file with the same name (using object prefix 'Object.'): " + Utils.arrayToString((Object)this.getExtensions());
    }

    public String[] getExtensions() {
        return new JAIImageReader().getFormatExtensions();
    }

    protected PreviewPanel createPreview(File file) {
        ImagePanel panel = new ImagePanel();
        Report report = null;
        File reportFile = FileUtils.replaceExtension((File)file, (String)".json");
        if (reportFile.exists() && reportFile.isFile()) {
            ViaAnnotationsReportReader reportReader = new ViaAnnotationsReportReader();
            reportReader.setLabelKey("type");
            reportReader.setInput(new PlaceholderFile(reportFile));
            List reports = reportReader.read();
            if (reports.size() > 0) {
                report = (Report)reports.get(0);
                ByMetaDataStringValue filter = new ByMetaDataStringValue();
                filter.setKey("filename");
                filter.setRegExp(new BaseRegExp(file.getName()));
                LocatedObjects lobjs = filter.findObjects(report);
                if (lobjs.size() > 0) {
                    report = lobjs.toReport("Object.");
                }
                ObjectLocationsOverlayFromReport overlay = new ObjectLocationsOverlayFromReport();
                overlay.setPrefix("Object.");
                panel.addImageOverlay((ImageOverlay)overlay);
            }
        }
        panel.load(file, (AbstractImageReader)new JAIImageReader(), -1.0);
        panel.setAdditionalProperties(report);
        panel.addLeftClickListener((ImagePanelLeftClickListener)new ViewObjects());
        return new PreviewPanel((JComponent)panel, (JComponent)panel.getPaintPanel());
    }
}

