/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.leftclick;

import adams.core.Properties;
import adams.data.report.Report;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.core.GUIHelper;
import adams.gui.core.PropertiesParameterPanel;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.dialog.SpreadSheetPanel;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.leftclick.AbstractLeftClickProcessor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.JPanel;

public class AddMetaData
extends AbstractLeftClickProcessor {
    private static final long serialVersionUID = -5747047661002140048L;
    protected String m_Prefix;
    protected transient String m_LastField;
    protected transient String m_LastValue;
    protected transient String m_LastType;

    public String globalInfo() {
        return "Allows the user to add meta-data to the selected objects.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)this.getDefaultPrefix());
    }

    protected String getDefaultPrefix() {
        return "Object.";
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix to use for the fields in the report of the image.";
    }

    protected void doProcessClick(ImagePanel panel, Point position, int modifiersEx) {
        LocatedObjects objects = LocatedObjects.fromReport(panel.getAdditionalProperties(), this.m_Prefix);
        LocatedObjects hits = new LocatedObjects();
        Point location = panel.mouseToPixelLocation(position);
        for (LocatedObject object : objects) {
            boolean add = object.hasPolygon() ? object.getActualPolygon().contains(location) : object.getActualRectangle().contains(location);
            if (!add) continue;
            hits.add(object.getClone());
        }
        if (hits.size() > 0) {
            SpreadSheet sheet = null;
            for (LocatedObject hit : hits) {
                SpreadSheet sheetHit = hit.toSpreadSheet();
                if (sheet == null) {
                    sheet = sheetHit;
                    continue;
                }
                sheet.addRow().assign((Row)sheetHit.getRow(0));
            }
            SpreadSheetPanel sheetPanel = new SpreadSheetPanel();
            sheetPanel.setSpreadSheet(sheet);
            sheetPanel.setShowSearch(true);
            PropertiesParameterPanel propsPanel = new PropertiesParameterPanel();
            ArrayList<String> order = new ArrayList<String>();
            propsPanel.addPropertyType("name", PropertiesParameterPanel.PropertyType.STRING);
            propsPanel.setLabel("name", "_Name");
            propsPanel.setHelp("name", "The name of the field");
            order.add("name");
            propsPanel.addPropertyType("type", PropertiesParameterPanel.PropertyType.LIST);
            propsPanel.setList("type", new String[]{"N", "S", "B", "U"});
            propsPanel.setLabel("type", "Type");
            propsPanel.setHelp("type", "The name of the field");
            if (this.m_LastType != null) {
                propsPanel.setListDefault("type", this.m_LastType);
            }
            order.add("type");
            propsPanel.addPropertyType("value", PropertiesParameterPanel.PropertyType.STRING);
            propsPanel.setLabel("value", "_Value");
            propsPanel.setHelp("value", "The value for the field");
            order.add("value");
            Properties props = new Properties();
            props.setProperty("name", this.m_LastField == null ? "field" : this.m_LastField);
            props.setProperty("type", this.m_LastType == null ? "N" : this.m_LastType);
            if (hits.size() == 1 && ((LocatedObject)hits.get(0)).getMetaData().containsKey(this.m_LastField)) {
                props.setProperty("value", "" + ((LocatedObject)hits.get(0)).getMetaData().get(this.m_LastField));
            } else {
                props.setProperty("value", this.m_LastValue == null ? "0.0" : this.m_LastValue);
            }
            propsPanel.setPropertyOrder(order);
            propsPanel.setProperties(props);
            JPanel contentPanel = new JPanel(new BorderLayout());
            contentPanel.add((Component)sheetPanel, "Center");
            contentPanel.add((Component)propsPanel, "South");
            ApprovalDialog dialog = panel.getParentDialog() != null ? new ApprovalDialog(panel.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new ApprovalDialog(panel.getParentFrame(), true);
            dialog.setDefaultCloseOperation(2);
            dialog.setTitle("Add meta-data");
            dialog.getContentPane().add((Component)contentPanel, "Center");
            dialog.setSize(GUIHelper.getDefaultDialogDimension());
            dialog.setLocationRelativeTo((Component)panel);
            dialog.setVisible(true);
            if (dialog.getOption() != 0) {
                return;
            }
            props = propsPanel.getProperties();
            this.m_LastField = props.getProperty("name");
            this.m_LastType = props.getProperty("type");
            this.m_LastValue = props.getProperty("value");
            for (LocatedObject hit : hits) {
                Object value;
                switch (this.m_LastType) {
                    case "N": {
                        value = props.getDouble("value");
                        break;
                    }
                    case "B": {
                        value = props.getBoolean("value");
                        break;
                    }
                    default: {
                        value = props.getProperty("value");
                    }
                }
                if (value == null) continue;
                hit.getMetaData().put(this.m_LastField, value);
            }
            objects.removeAll(hits);
            objects.addAll(hits);
            Report report = panel.getAdditionalProperties().getClone();
            report.removeValuesStartingWith(this.m_Prefix);
            Report reportNew = objects.toReport(this.m_Prefix);
            reportNew.mergeWith(report);
            panel.setAdditionalProperties(reportNew);
        }
    }
}

