/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.leftclick;

import adams.data.report.Report;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.SpreadSheetDialog;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.leftclick.AbstractLeftClickProcessor;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;

public class DeleteObjects
extends AbstractLeftClickProcessor {
    private static final long serialVersionUID = -5747047661002140048L;
    protected String m_Prefix;

    public String globalInfo() {
        return "Displays the objects at the click position and deletes the selected ones.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)this.getDefaultPrefix());
    }

    protected String getDefaultPrefix() {
        return "Object.";
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix to use for the fields in the report of the image.";
    }

    protected void doProcessClick(ImagePanel panel, Point position, int modifiersEx) {
        LocatedObjects objects = LocatedObjects.fromReport(panel.getAllProperties(), this.m_Prefix);
        LocatedObjects hits = new LocatedObjects();
        Point location = panel.mouseToPixelLocation(position);
        for (LocatedObject object : objects) {
            boolean add = object.hasPolygon() ? object.getActualPolygon().contains(location) : object.getActualRectangle().contains(location);
            if (!add) continue;
            hits.add(object);
        }
        if (hits.size() > 0) {
            SpreadSheet sheet = null;
            for (LocatedObject hit : hits) {
                SpreadSheet sheetHit = hit.toSpreadSheet();
                if (sheet == null) {
                    sheet = sheetHit;
                    continue;
                }
                sheet.addRow().assign((Row)sheetHit.getRow(0));
            }
            SpreadSheetDialog dialog = panel.getParentDialog() != null ? new SpreadSheetDialog(panel.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new SpreadSheetDialog(panel.getParentFrame(), true);
            dialog.setDefaultCloseOperation(2);
            dialog.setTitle("Select objects to remove");
            dialog.setSize(GUIHelper.getDefaultDialogDimension());
            dialog.setLocationRelativeTo((Component)panel);
            dialog.setSpreadSheet(sheet);
            dialog.setShowSearch(true);
            dialog.setVisible(true);
            if (dialog.getOption() != 0) {
                return;
            }
            int[] rows = dialog.getTable().getSelectedRows();
            if (rows.length == 0) {
                return;
            }
            for (Object row : (Object)rows) {
                objects.remove(hits.get((int)row));
            }
            Report report = panel.getAdditionalProperties().getClone();
            report.removeValuesStartingWith(this.m_Prefix);
            Report reportNew = objects.toReport(this.m_Prefix);
            reportNew.mergeWith(report);
            panel.setAdditionalProperties(reportNew);
        }
    }
}

