/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.plugins;

import adams.core.logging.LoggingHelper;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.transformer.metadata.AbstractMetaDataExtractor;
import adams.flow.transformer.metadata.ApacheCommons;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.SpreadSheetDialog;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.plugins.AbstractImageViewerPluginWithGOE;

public class ImageFileMetaData
extends AbstractImageViewerPluginWithGOE {
    private static final long serialVersionUID = -3146372359577147914L;

    public String getMenu() {
        return "Process";
    }

    public String getCaption() {
        return "Image file meta-data";
    }

    public String getIconName() {
        return "imagemetadata.png";
    }

    public boolean canExecute(ImagePanel panel) {
        return panel != null && panel.getCurrentImage() != null && panel.getCurrentFile() != null && !panel.isModified();
    }

    protected String createLogEntry() {
        return null;
    }

    protected Class getEditorType() {
        return AbstractMetaDataExtractor.class;
    }

    protected Object getDefaultValue() {
        return new ApacheCommons();
    }

    protected String process() {
        String result = null;
        if (((ImagePanel)this.m_CurrentPanel).getCurrentFile() == null || ((ImagePanel)this.m_CurrentPanel).isModified()) {
            return result;
        }
        try {
            AbstractMetaDataExtractor extractor = (AbstractMetaDataExtractor)((Object)this.getLastSetup());
            SpreadSheet sheet = extractor.extract(((ImagePanel)this.m_CurrentPanel).getCurrentFile());
            SpreadSheetDialog dialog = ((ImagePanel)this.m_CurrentPanel).getParentDialog() != null ? new SpreadSheetDialog(((ImagePanel)this.m_CurrentPanel).getParentDialog()) : new SpreadSheetDialog(((ImagePanel)this.m_CurrentPanel).getParentFrame());
            dialog.setTitle("Meta-data - " + ((ImagePanel)this.m_CurrentPanel).getCurrentFile().getName() + " [" + ((ImagePanel)this.m_CurrentPanel).getCurrentFile().getParent() + "]");
            dialog.setSpreadSheet(sheet);
            dialog.setShowSearch(true);
            dialog.setSize(GUIHelper.getInteger((String)"DefaultSmallDialog.Width", (Integer)600).intValue(), GUIHelper.getInteger((String)"DefaultSmallDialog.Width", (Integer)600).intValue());
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            result = "Failed to read meta-data from file '" + ((ImagePanel)this.m_CurrentPanel).getCurrentFile() + "': " + LoggingHelper.throwableToString((Throwable)e);
        }
        return result;
    }
}

