/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.selection;

import adams.data.report.Report;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.selection.AbstractSelectionProcessor;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.List;

public class Crop
extends AbstractSelectionProcessor {
    private static final long serialVersionUID = -657789971297807743L;
    public static final String PREFIX = "Crop.";
    public static final String KEY_X = "x";
    public static final String KEY_Y = "y";
    public static final String KEY_WIDTH = "width";
    public static final String KEY_HEIGHT = "height";

    public String globalInfo() {
        return "Crops the image to the current selection and stores crop information in the report (prefix: Crop.). Offers undo/redo.";
    }

    protected void doProcessSelection(ImagePanel panel, Point topLeft, Point bottomRight, List<Point> trace, int modifiersEx) {
        int x = panel.mouseToPixelLocation((Point)topLeft).x;
        int y = panel.mouseToPixelLocation((Point)topLeft).y;
        int width = panel.mouseToPixelLocation((Point)bottomRight).x - panel.mouseToPixelLocation((Point)topLeft).x + 1;
        int height = panel.mouseToPixelLocation((Point)bottomRight).y - panel.mouseToPixelLocation((Point)topLeft).y + 1;
        Report additional = new Report();
        additional.setNumericValue("Crop.x", (double)x);
        additional.setNumericValue("Crop.y", (double)y);
        additional.setNumericValue("Crop.width", (double)width);
        additional.setNumericValue("Crop.height", (double)height);
        BufferedImage cropped = panel.getCurrentImage().getSubimage(x, y, width, height);
        panel.addUndoPoint("Saving undo data...", "Crop");
        panel.setCurrentImage(cropped);
        panel.setAdditionalProperties(additional);
    }
}

