/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.object.annotator;

import adams.core.CleanUpHandler;
import adams.core.option.AbstractOptionHandler;
import adams.gui.visualization.object.ObjectAnnotationPanel;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;

public abstract class AbstractAnnotator
extends AbstractOptionHandler
implements CleanUpHandler {
    private static final long serialVersionUID = -7284521891609621197L;
    protected ObjectAnnotationPanel m_Owner;
    protected boolean m_Selecting;

    protected void initialize() {
        super.initialize();
        this.m_Owner = null;
        this.m_Selecting = false;
    }

    public void setOwner(ObjectAnnotationPanel value) {
        this.m_Owner = value;
    }

    public ObjectAnnotationPanel getOwner() {
        return this.m_Owner;
    }

    protected abstract void doInstall();

    public void install() {
        if (this.m_Owner == null) {
            throw new IllegalStateException("No owner set, cannot install!");
        }
        this.doInstall();
    }

    protected abstract void doUninstall();

    public void uninstall() {
        if (this.m_Owner == null) {
            throw new IllegalStateException("No owner set, cannot uninstall!");
        }
        this.doUninstall();
    }

    public boolean hasCurrentLabel() {
        return this.getCurrentLabel() != null && !this.getCurrentLabel().isEmpty();
    }

    public String getCurrentLabel() {
        return this.getOwner().getCurrentLabel();
    }

    public void labelChanged() {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Label changed: " + (this.hasCurrentLabel() ? this.getCurrentLabel() : "[not set]"));
        }
    }

    protected float getStrokeWidth(Graphics g, float defValue) {
        Graphics2D g2d;
        if (g instanceof Graphics2D && (g2d = (Graphics2D)g).getStroke() instanceof BasicStroke) {
            return ((BasicStroke)g2d.getStroke()).getLineWidth();
        }
        return defValue;
    }

    protected void applyStroke(Graphics g, float stroke) {
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(new BasicStroke(stroke));
        }
    }

    protected abstract void doPaintSelection(Graphics var1);

    public void paintSelection(Graphics g) {
        if (!this.m_Selecting) {
            return;
        }
        this.doPaintSelection(g);
    }

    public void cleanUp() {
    }
}

