/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.object.annotator;

import adams.core.Utils;
import adams.data.report.Report;
import adams.gui.visualization.image.RectangleUtils;
import adams.gui.visualization.image.SelectionRectangle;
import adams.gui.visualization.object.annotator.AbstractRectangleBasedAnnotator;
import adams.gui.visualization.object.annotator.LabelSuffixHandler;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;

public class BoundingBoxAnnotator
extends AbstractRectangleBasedAnnotator
implements LabelSuffixHandler {
    private static final long serialVersionUID = 1122040195846360397L;
    protected Color m_Color;
    protected float m_StrokeThickness;
    protected String m_LabelSuffix;
    protected boolean m_Dragged;
    protected Point m_SelectionFrom;
    protected Point m_SelectionTo;
    protected MouseListener m_MouseListener;
    protected MouseMotionListener m_MouseMotionListener;

    public String globalInfo() {
        return "For annotating objects with bounding boxes.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color", "color", (Object)Color.GRAY);
        this.m_OptionManager.add("stroke-thickness", "strokeThickness", (Object)Float.valueOf(1.0f), (Number)Float.valueOf(0.01f), null);
        this.m_OptionManager.add("label-suffix", "labelSuffix", (Object)this.getDefaultLabelSuffix());
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color to use for drawing the box while dragging.";
    }

    public void setStrokeThickness(float value) {
        this.m_StrokeThickness = value;
        this.reset();
    }

    public float getStrokeThickness() {
        return this.m_StrokeThickness;
    }

    public String strokeThicknessTipText() {
        return "The thickness of the stroke for the box.";
    }

    protected String getDefaultLabel() {
        return "";
    }

    protected String getDefaultLabelSuffix() {
        return ".type";
    }

    @Override
    public void setLabelSuffix(String value) {
        this.m_LabelSuffix = value;
        this.reset();
    }

    @Override
    public String getLabelSuffix() {
        return this.m_LabelSuffix;
    }

    public String labelSuffixTipText() {
        return "The suffix to use for storing the label in the report.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Dragged = false;
        this.m_SelectionFrom = null;
        this.m_SelectionTo = null;
        this.m_MouseListener = this.createMouseListener();
        this.m_MouseMotionListener = this.createMouseMotionListener();
    }

    protected MouseListener createMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                BoundingBoxAnnotator.this.getOwner().getCanvas().logMouseButtonPressed(e);
                if (e.getButton() == 1 && !e.isShiftDown()) {
                    BoundingBoxAnnotator.this.m_Selecting = true;
                    BoundingBoxAnnotator.this.m_Dragged = false;
                    BoundingBoxAnnotator.this.m_SelectionFrom = e.getPoint();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (e.getButton() == 1 && !e.isShiftDown()) {
                    BoundingBoxAnnotator.this.m_Selecting = true;
                    BoundingBoxAnnotator.this.m_Dragged = false;
                    BoundingBoxAnnotator.this.m_SelectionFrom = e.getPoint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                BoundingBoxAnnotator.this.getOwner().getCanvas().logMouseButtonReleased(e);
                if (e.getButton() == 1 && BoundingBoxAnnotator.this.m_Selecting && BoundingBoxAnnotator.this.m_Dragged) {
                    BoundingBoxAnnotator.this.m_Selecting = false;
                    BoundingBoxAnnotator.this.m_Dragged = false;
                    BoundingBoxAnnotator.this.m_SelectionTo = e.getPoint();
                    BoundingBoxAnnotator.this.processSelection(e.getModifiersEx());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                BoundingBoxAnnotator.this.getOwner().getCanvas().logMouseButtonClick(e);
            }
        };
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (BoundingBoxAnnotator.this.m_Selecting && !e.isShiftDown()) {
                    BoundingBoxAnnotator.this.m_Dragged = true;
                    BoundingBoxAnnotator.this.m_SelectionTo = e.getPoint();
                    BoundingBoxAnnotator.this.getOwner().update();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (e.getButton() == 1 && !e.isShiftDown()) {
                    BoundingBoxAnnotator.this.m_Selecting = true;
                    BoundingBoxAnnotator.this.m_Dragged = false;
                    BoundingBoxAnnotator.this.m_SelectionFrom = e.getPoint();
                }
            }
        };
    }

    protected void processSelection(int modifiersEx) {
        if (this.m_SelectionFrom == null || this.m_SelectionTo == null) {
            return;
        }
        Point topLeft = RectangleUtils.rectangleCorner((Point)this.m_SelectionFrom, (Point)this.m_SelectionTo, (RectangleUtils.RectangleCorner)RectangleUtils.RectangleCorner.TOP_LEFT);
        Point bottomRight = RectangleUtils.rectangleCorner((Point)this.m_SelectionFrom, (Point)this.m_SelectionTo, (RectangleUtils.RectangleCorner)RectangleUtils.RectangleCorner.BOTTOM_RIGHT);
        String comment = "";
        Report report = this.getOwner().getReport().getClone();
        if (this.m_Locations == null) {
            this.m_Locations = this.getLocations(report);
        }
        int x = this.getOwner().mouseToPixelLocation((Point)topLeft).x;
        int y = this.getOwner().mouseToPixelLocation((Point)topLeft).y;
        int w = this.getOwner().mouseToPixelLocation((Point)bottomRight).x - this.getOwner().mouseToPixelLocation((Point)topLeft).x + 1;
        int h = this.getOwner().mouseToPixelLocation((Point)bottomRight).y - this.getOwner().mouseToPixelLocation((Point)topLeft).y + 1;
        SelectionRectangle rect = new SelectionRectangle(x, y, w, h, -1);
        if (w == 0 || h == 0) {
            return;
        }
        ArrayList<SelectionRectangle> queue = new ArrayList<SelectionRectangle>();
        boolean modified = false;
        if ((modifiersEx & 0x80) != 0) {
            for (SelectionRectangle r : this.m_Locations) {
                if (!rect.contains(r) || !this.removeIndex(report, r.getIndex())) continue;
                modified = true;
                queue.add(r);
            }
            this.m_Locations.removeAll(queue);
            comment = "Removing " + queue.size() + " boxes";
        } else if (!this.m_Locations.contains(rect)) {
            modified = true;
            int lastIndex = this.findLastIndex(report);
            rect.setIndex(lastIndex + 1);
            String current = this.m_Prefix + Utils.padLeft((String)("" + rect.getIndex()), (char)'0', (int)this.m_NumDigits);
            report.setNumericValue(current + ".x", (double)x);
            report.setNumericValue(current + ".y", (double)y);
            report.setNumericValue(current + ".width", (double)w);
            report.setNumericValue(current + ".height", (double)h);
            if (this.hasCurrentLabel()) {
                report.setStringValue(current + this.m_LabelSuffix, this.getCurrentLabel());
            }
            this.m_Locations.add(rect);
            comment = "Adding box: " + rect;
        }
        if (modified) {
            this.getOwner().addUndoPoint(comment);
            this.getOwner().setReport(report);
            this.getOwner().annotationsChanged(this);
            this.getOwner().update();
        }
    }

    @Override
    protected void doInstall() {
        this.getOwner().getCanvas().addMouseListener(this.m_MouseListener);
        this.getOwner().getCanvas().addMouseMotionListener(this.m_MouseMotionListener);
    }

    @Override
    protected void doUninstall() {
        this.getOwner().getCanvas().removeMouseListener(this.m_MouseListener);
        this.getOwner().getCanvas().removeMouseMotionListener(this.m_MouseMotionListener);
    }

    @Override
    protected void doPaintSelection(Graphics g) {
        int tmp;
        if (this.m_SelectionFrom == null || this.m_SelectionTo == null) {
            return;
        }
        float width = this.getStrokeWidth(g, 1.0f);
        this.applyStroke(g, this.m_StrokeThickness);
        Point topLeft = RectangleUtils.rectangleCorner((Point)this.m_SelectionFrom, (Point)this.m_SelectionTo, (RectangleUtils.RectangleCorner)RectangleUtils.RectangleCorner.TOP_LEFT);
        Point bottomRight = RectangleUtils.rectangleCorner((Point)this.m_SelectionFrom, (Point)this.m_SelectionTo, (RectangleUtils.RectangleCorner)RectangleUtils.RectangleCorner.BOTTOM_RIGHT);
        g.setColor(this.m_Color);
        int topX = (int)this.getOwner().mouseToPixelLocation(topLeft).getX();
        int topY = (int)this.getOwner().mouseToPixelLocation(topLeft).getY();
        int bottomX = (int)this.getOwner().mouseToPixelLocation(bottomRight).getX();
        int bottomY = (int)this.getOwner().mouseToPixelLocation(bottomRight).getY();
        if (topX > bottomX) {
            tmp = topX;
            topX = bottomX;
            bottomX = tmp;
        }
        if (topY > bottomY) {
            tmp = topY;
            topY = bottomY;
            bottomY = tmp;
        }
        g.drawRect(topX, topY, bottomX - topX + 1, bottomY - topY + 1);
        this.applyStroke(g, width);
    }
}

