/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.object.annotator;

import adams.core.Utils;
import adams.data.report.Report;
import adams.data.statistics.StatUtils;
import adams.gui.visualization.image.SelectionRectangle;
import adams.gui.visualization.object.annotator.AbstractRectangleBasedAnnotator;
import adams.gui.visualization.object.annotator.LabelSuffixHandler;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;

public class PolygonAnnotator
extends AbstractRectangleBasedAnnotator
implements LabelSuffixHandler {
    private static final long serialVersionUID = 1122040195846360397L;
    protected Color m_Color;
    protected float m_StrokeThickness;
    protected int m_MinDistance;
    protected String m_LabelSuffix;
    protected boolean m_Dragged;
    protected Point m_SelectionFrom;
    protected Point m_SelectionTo;
    protected List<Point> m_SelectionTrace;
    protected MouseListener m_MouseListener;
    protected MouseMotionListener m_MouseMotionListener;

    public String globalInfo() {
        return "For annotating objects with bounding boxes.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color", "color", (Object)Color.GRAY);
        this.m_OptionManager.add("stroke-thickness", "strokeThickness", (Object)Float.valueOf(1.0f), (Number)Float.valueOf(0.01f), null);
        this.m_OptionManager.add("min-distance", "minDistance", (Object)10, (Number)1, null);
        this.m_OptionManager.add("label-suffix", "labelSuffix", (Object)this.getDefaultLabelSuffix());
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color to use for drawing the box while dragging.";
    }

    public void setStrokeThickness(float value) {
        this.m_StrokeThickness = value;
        this.reset();
    }

    public float getStrokeThickness() {
        return this.m_StrokeThickness;
    }

    public String strokeThicknessTipText() {
        return "The thickness of the stroke for the box.";
    }

    public void setMinDistance(int value) {
        this.m_MinDistance = value;
        this.reset();
    }

    public int getMinDistance() {
        return this.m_MinDistance;
    }

    public String minDistanceTipText() {
        return "The minimum distance in pixels that a new point must be away from the last trace point.";
    }

    protected String getDefaultLabelSuffix() {
        return ".type";
    }

    @Override
    public void setLabelSuffix(String value) {
        this.m_LabelSuffix = value;
        this.reset();
    }

    @Override
    public String getLabelSuffix() {
        return this.m_LabelSuffix;
    }

    public String labelSuffixTipText() {
        return "The suffix to use for storing the label in the report.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Dragged = false;
        this.m_SelectionFrom = null;
        this.m_SelectionTo = null;
        this.m_SelectionTrace = new ArrayList<Point>();
        this.m_MouseListener = this.createMouseListener();
        this.m_MouseMotionListener = this.createMouseMotionListener();
    }

    protected MouseListener createMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PolygonAnnotator.this.getOwner().getCanvas().logMouseButtonPressed(e);
                if (e.getButton() == 1 && !e.isShiftDown()) {
                    PolygonAnnotator.this.m_Selecting = true;
                    PolygonAnnotator.this.m_Dragged = false;
                    PolygonAnnotator.this.m_SelectionFrom = e.getPoint();
                    PolygonAnnotator.this.m_SelectionTrace.clear();
                    if (PolygonAnnotator.this.canAddTracePoint(e.getPoint())) {
                        PolygonAnnotator.this.m_SelectionTrace.add(e.getPoint());
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (e.getButton() == 1 && !e.isShiftDown()) {
                    PolygonAnnotator.this.m_Selecting = true;
                    PolygonAnnotator.this.m_Dragged = false;
                    PolygonAnnotator.this.m_SelectionFrom = e.getPoint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PolygonAnnotator.this.getOwner().getCanvas().logMouseButtonReleased(e);
                if (e.getButton() == 1 && PolygonAnnotator.this.m_Selecting && PolygonAnnotator.this.m_Dragged) {
                    PolygonAnnotator.this.m_Selecting = false;
                    PolygonAnnotator.this.m_Dragged = false;
                    PolygonAnnotator.this.m_SelectionTo = e.getPoint();
                    PolygonAnnotator.this.processSelection(e.getModifiersEx());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                PolygonAnnotator.this.getOwner().getCanvas().logMouseButtonClick(e);
            }
        };
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (PolygonAnnotator.this.m_Selecting && !e.isShiftDown()) {
                    PolygonAnnotator.this.m_Dragged = true;
                    PolygonAnnotator.this.m_SelectionTo = e.getPoint();
                    if (PolygonAnnotator.this.canAddTracePoint(e.getPoint())) {
                        PolygonAnnotator.this.m_SelectionTrace.add(e.getPoint());
                    }
                    PolygonAnnotator.this.getOwner().update();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (e.getButton() == 1 && !e.isShiftDown()) {
                    PolygonAnnotator.this.m_Selecting = true;
                    PolygonAnnotator.this.m_Dragged = false;
                    PolygonAnnotator.this.m_SelectionFrom = e.getPoint();
                }
            }
        };
    }

    public boolean canAddTracePoint(Point p) {
        if (this.m_SelectionTrace.size() == 0) {
            return true;
        }
        Point last = this.m_SelectionTrace.get(this.m_SelectionTrace.size() - 1);
        double dist = Math.sqrt(Math.pow(p.getX() - last.getX(), 2.0) + Math.pow(p.getY() - last.getY(), 2.0));
        return dist >= (double)this.m_MinDistance;
    }

    public Polygon traceToPolygon() {
        Polygon result = null;
        if (this.m_SelectionTrace.size() > 0) {
            int[] poly_x = new int[this.m_SelectionTrace.size()];
            int[] poly_y = new int[this.m_SelectionTrace.size()];
            for (int i = 0; i < this.m_SelectionTrace.size(); ++i) {
                Point p = this.getOwner().mouseToPixelLocation(this.m_SelectionTrace.get(i));
                poly_x[i] = (int)p.getX();
                poly_y[i] = (int)p.getY();
            }
            result = new Polygon(poly_x, poly_y, poly_x.length);
        }
        return result;
    }

    protected void processSelection(int modifiersEx) {
        if (this.m_SelectionTrace.size() == 0) {
            return;
        }
        String comment = "";
        Report report = this.getOwner().getReport().getClone();
        if (this.m_Locations == null) {
            this.m_Locations = this.getLocations(report);
        }
        Polygon poly = this.traceToPolygon();
        Rectangle bounds = poly.getBounds();
        int x = (int)bounds.getX();
        int y = (int)bounds.getY();
        int w = (int)bounds.getWidth();
        int h = (int)bounds.getHeight();
        SelectionRectangle rect = new SelectionRectangle(x, y, w, h, -1);
        if (w == 0 || h == 0) {
            return;
        }
        ArrayList<SelectionRectangle> queue = new ArrayList<SelectionRectangle>();
        boolean modified = false;
        if ((modifiersEx & 0x80) != 0) {
            for (SelectionRectangle r : this.m_Locations) {
                if (!rect.contains(r) || !this.removeIndex(report, r.getIndex())) continue;
                modified = true;
                queue.add(r);
            }
            this.m_Locations.removeAll(queue);
            comment = "Removing " + queue.size() + " polygons";
        } else if (!this.m_Locations.contains(rect)) {
            modified = true;
            int lastIndex = this.findLastIndex(report);
            rect.setIndex(lastIndex + 1);
            String current = this.m_Prefix + Utils.padLeft((String)("" + rect.getIndex()), (char)'0', (int)this.m_NumDigits);
            report.setNumericValue(current + ".x", (double)x);
            report.setNumericValue(current + ".y", (double)y);
            report.setNumericValue(current + ".width", (double)w);
            report.setNumericValue(current + ".height", (double)h);
            int[] poly_x = new int[this.m_SelectionTrace.size()];
            int[] poly_y = new int[this.m_SelectionTrace.size()];
            for (int i = 0; i < this.m_SelectionTrace.size(); ++i) {
                poly_x[i] = (int)this.getOwner().mouseToPixelLocation(this.m_SelectionTrace.get(i)).getX();
                poly_y[i] = (int)this.getOwner().mouseToPixelLocation(this.m_SelectionTrace.get(i)).getY();
            }
            report.setStringValue(current + ".poly_x", Utils.flatten((Object[])StatUtils.toNumberArray((int[])poly_x), (String)","));
            report.setStringValue(current + ".poly_y", Utils.flatten((Object[])StatUtils.toNumberArray((int[])poly_y), (String)","));
            if (this.hasCurrentLabel()) {
                report.setStringValue(current + this.m_LabelSuffix, this.getCurrentLabel());
            }
            this.m_Locations.add(rect);
            comment = "Adding polygon: " + rect;
        }
        if (modified) {
            this.getOwner().addUndoPoint(comment);
            this.getOwner().setReport(report);
            this.getOwner().annotationsChanged(this);
            this.getOwner().update();
        }
    }

    @Override
    protected void doInstall() {
        this.getOwner().getCanvas().addMouseListener(this.m_MouseListener);
        this.getOwner().getCanvas().addMouseMotionListener(this.m_MouseMotionListener);
    }

    @Override
    protected void doUninstall() {
        this.getOwner().getCanvas().removeMouseListener(this.m_MouseListener);
        this.getOwner().getCanvas().removeMouseMotionListener(this.m_MouseMotionListener);
    }

    @Override
    protected void doPaintSelection(Graphics g) {
        if (this.m_SelectionTrace.size() == 0) {
            return;
        }
        float width = this.getStrokeWidth(g, 1.0f);
        this.applyStroke(g, this.m_StrokeThickness);
        g.setColor(this.m_Color);
        Polygon poly = this.traceToPolygon();
        g.drawPolygon(poly.xpoints, poly.ypoints, poly.npoints);
        this.applyStroke(g, width);
    }
}

