/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.object.labelselector;

import adams.core.base.BaseString;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseToggleButton;
import adams.gui.visualization.object.ObjectAnnotationPanel;
import adams.gui.visualization.object.labelselector.AbstractLabelSelectorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;

public class ButtonSelectorPanel
extends AbstractLabelSelectorPanel {
    private static final long serialVersionUID = -5878687744017979355L;
    protected BaseString[] m_Labels;
    protected BaseToggleButton[] m_ButtonLabels;
    protected BaseToggleButton m_ButtonUnset;
    protected ButtonGroup m_ButtonGroup;

    public ButtonSelectorPanel(ObjectAnnotationPanel owner, BaseString[] labels) {
        super(owner);
        this.m_Labels = labels;
        this.initialize();
        this.initGUI();
        this.finishInit();
    }

    @Override
    protected void initialize() {
        if (this.m_Labels == null) {
            return;
        }
        super.initialize();
    }

    protected void initGUI() {
        GridBagConstraints con;
        int i;
        if (this.m_Labels == null) {
            return;
        }
        super.initGUI();
        this.setLayout(new BorderLayout());
        int gapHorizontal = 5;
        int gapVertical = 2;
        GridBagLayout layout = new GridBagLayout();
        JPanel panelButtons = new JPanel(layout);
        this.add((Component)new BaseScrollPane((Component)panelButtons), "Center");
        this.m_ButtonGroup = new ButtonGroup();
        ArrayList<BaseToggleButton> comps = new ArrayList<BaseToggleButton>();
        this.m_ButtonLabels = new BaseToggleButton[this.m_Labels.length];
        for (i = 0; i < this.m_Labels.length; ++i) {
            String label = this.m_Labels[i].getValue();
            this.m_ButtonLabels[i] = new BaseToggleButton(label);
            this.m_ButtonLabels[i].addActionListener(e -> this.setCurrentLabel(label));
            if (i == 0) {
                this.m_ButtonLabels[i].setSelected(true);
            }
            this.m_ButtonGroup.add((AbstractButton)this.m_ButtonLabels[i]);
            comps.add(this.m_ButtonLabels[i]);
        }
        this.m_ButtonUnset = new BaseToggleButton("Unset");
        this.m_ButtonUnset.addActionListener(e -> this.setCurrentLabel(null));
        comps.add(this.m_ButtonUnset);
        this.m_ButtonGroup.add((AbstractButton)this.m_ButtonUnset);
        for (i = 0; i < comps.size(); ++i) {
            con = new GridBagConstraints();
            con.anchor = 17;
            con.fill = 2;
            con.gridy = i;
            con.gridx = 0;
            con.weightx = 100.0;
            con.ipadx = 20;
            con.insets = new Insets(gapVertical, gapHorizontal, gapVertical, gapHorizontal);
            layout.setConstraints((Component)comps.get(i), con);
            panelButtons.add((Component)comps.get(i));
        }
        JPanel panel = new JPanel();
        con = new GridBagConstraints();
        con.anchor = 17;
        con.fill = 1;
        con.gridy = comps.size();
        con.gridx = 0;
        con.weighty = 100.0;
        con.gridwidth = 0;
        layout.setConstraints(panel, con);
        panelButtons.add(panel);
    }

    protected void finishInit() {
        if (this.m_Labels == null) {
            return;
        }
        super.finishInit();
        if (this.m_ButtonLabels.length > 0) {
            this.m_ButtonLabels[0].doClick();
        }
    }

    @Override
    protected void doPreselectCurrentLabel(String label) {
        this.m_ButtonGroup.clearSelection();
        if (label == null) {
            return;
        }
        for (int i = 0; i < this.m_ButtonLabels.length; ++i) {
            if (!this.m_ButtonLabels[i].getText().equals(label)) continue;
            this.m_ButtonLabels[i].doClick();
            break;
        }
    }
}

