/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.object.labelselector;

import adams.core.base.BaseObject;
import adams.core.base.BaseString;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseComboBox;
import adams.gui.core.BaseScrollPane;
import adams.gui.visualization.object.ObjectAnnotationPanel;
import adams.gui.visualization.object.labelselector.AbstractLabelSelectorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JPanel;

public class ComboBoxSelectorPanel
extends AbstractLabelSelectorPanel {
    private static final long serialVersionUID = -5878687744017979355L;
    protected BaseString[] m_Labels;
    protected BaseComboBox<String> m_ComboBoxLabels;
    protected BaseButton m_ButtonUnset;

    public ComboBoxSelectorPanel(ObjectAnnotationPanel owner, BaseString[] labels) {
        super(owner);
        this.m_Labels = labels;
        this.initialize();
        this.initGUI();
        this.finishInit();
    }

    @Override
    protected void initialize() {
        if (this.m_Labels == null) {
            return;
        }
        super.initialize();
    }

    protected void initGUI() {
        GridBagConstraints con;
        if (this.m_Labels == null) {
            return;
        }
        super.initGUI();
        this.setLayout(new BorderLayout());
        ArrayList<Object> comps = new ArrayList<Object>();
        int gapHorizontal = 5;
        int gapVertical = 2;
        GridBagLayout layout = new GridBagLayout();
        JPanel panelButtons = new JPanel(layout);
        this.add((Component)new BaseScrollPane((Component)panelButtons), "Center");
        ArrayList<String> labels = new ArrayList<String>();
        labels.add("");
        labels.addAll(Arrays.asList(BaseObject.toStringArray((BaseObject[])this.m_Labels)));
        this.m_ComboBoxLabels = new BaseComboBox((Object[])labels.toArray(new String[0]));
        this.m_ComboBoxLabels.addActionListener(e -> this.setCurrentLabel((String)this.m_ComboBoxLabels.getSelectedItem()));
        comps.add(this.m_ComboBoxLabels);
        this.m_ButtonUnset = new BaseButton("Unset");
        this.m_ButtonUnset.addActionListener(e -> this.m_ComboBoxLabels.setSelectedIndex(0));
        comps.add(this.m_ButtonUnset);
        for (int i = 0; i < comps.size(); ++i) {
            con = new GridBagConstraints();
            con.anchor = 17;
            con.fill = 2;
            con.gridy = i;
            con.gridx = 0;
            con.weightx = 100.0;
            con.ipadx = 20;
            con.insets = new Insets(gapVertical, gapHorizontal, gapVertical, gapHorizontal);
            layout.setConstraints((Component)comps.get(i), con);
            panelButtons.add((Component)comps.get(i));
        }
        JPanel panel = new JPanel();
        con = new GridBagConstraints();
        con.anchor = 17;
        con.fill = 1;
        con.gridy = comps.size();
        con.gridx = 0;
        con.weighty = 100.0;
        con.gridwidth = 0;
        layout.setConstraints(panel, con);
        panelButtons.add(panel);
    }

    @Override
    public void setCurrentLabel(String value) {
        if (value.isEmpty()) {
            super.setCurrentLabel(null);
        } else {
            super.setCurrentLabel(value);
        }
    }

    protected void finishInit() {
        if (this.m_Labels == null) {
            return;
        }
        super.finishInit();
        if (this.m_Labels.length > 0) {
            this.m_ComboBoxLabels.setSelectedIndex(1);
        } else {
            this.m_ComboBoxLabels.setSelectedIndex(0);
        }
    }

    @Override
    protected void doPreselectCurrentLabel(String label) {
        if (label == null) {
            this.m_ComboBoxLabels.setSelectedIndex(0);
        } else {
            this.m_ComboBoxLabels.setSelectedItem((Object)label);
        }
    }
}

