/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.object.mouseclick;

import adams.gui.visualization.object.ObjectAnnotationPanel;
import adams.gui.visualization.object.mouseclick.AbstractMouseClickProcessor;
import java.awt.event.MouseEvent;

public class MultiProcessor
extends AbstractMouseClickProcessor {
    private static final long serialVersionUID = 8422134104160247274L;
    protected AbstractMouseClickProcessor[] m_Processors;

    public String globalInfo() {
        return "Combines multiple click processors, iterates through them until event consumed.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.removeByProperty("button");
        this.m_OptionManager.removeByProperty("shiftDown");
        this.m_OptionManager.removeByProperty("altDown");
        this.m_OptionManager.removeByProperty("ctrlDown");
        this.m_OptionManager.removeByProperty("metaDown");
        this.m_OptionManager.add("processor", "processors", (Object)new AbstractMouseClickProcessor[0]);
    }

    public MultiProcessor addProcessor(AbstractMouseClickProcessor value) {
        AbstractMouseClickProcessor[] processors = new AbstractMouseClickProcessor[this.m_Processors.length + 1];
        for (int i = 0; i < this.m_Processors.length; ++i) {
            processors[i] = this.m_Processors[i];
        }
        processors[processors.length - 1] = value;
        this.setProcessors(processors);
        return this;
    }

    public void setProcessors(AbstractMouseClickProcessor[] value) {
        this.m_Processors = value;
        this.reset();
    }

    public AbstractMouseClickProcessor[] getProcessors() {
        return this.m_Processors;
    }

    @Override
    protected void doProcess(ObjectAnnotationPanel panel, MouseEvent e) {
        for (int i = 0; i < this.m_Processors.length; ++i) {
            this.m_Processors[i].process(panel, e);
            if (e.isConsumed()) break;
        }
    }

    @Override
    public void process(ObjectAnnotationPanel panel, MouseEvent e) {
        if (!this.getEnabled()) {
            return;
        }
        this.doProcess(panel, e);
    }
}

