/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.segmentation;

import adams.data.RoundingUtils;
import adams.gui.core.BasePanel;
import adams.gui.core.MouseUtils;
import adams.gui.visualization.segmentation.SegmentationPanel;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class CanvasPanel
extends BasePanel {
    private static final long serialVersionUID = -1128271862782338556L;
    protected SegmentationPanel m_Owner;
    protected boolean m_LeftMouseDown;
    protected boolean m_RightMouseDown;

    protected void initialize() {
        super.initialize();
        this.m_LeftMouseDown = false;
        this.m_RightMouseDown = false;
    }

    protected void initGUI() {
        super.initGUI();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CanvasPanel.this.m_LeftMouseDown = MouseUtils.isLeftDown((MouseEvent)e);
                CanvasPanel.this.m_RightMouseDown = MouseUtils.isRightDown((MouseEvent)e);
                super.mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                CanvasPanel.this.m_LeftMouseDown = false;
                CanvasPanel.this.m_RightMouseDown = false;
                super.mouseReleased(e);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                double oldZoom = CanvasPanel.this.m_Owner.getZoom();
                int rotation = e.getWheelRotation();
                double newZoom = rotation < 0 ? oldZoom * Math.pow(1.4, -rotation) : oldZoom / Math.pow(1.4, rotation);
                newZoom = RoundingUtils.round((double)newZoom, (int)1);
                CanvasPanel.this.m_Owner.setZoom(newZoom);
            }
        });
    }

    public void setOwner(SegmentationPanel value) {
        this.m_Owner = value;
    }

    public SegmentationPanel getOwner() {
        return this.m_Owner;
    }

    public boolean isLeftMouseDown() {
        return this.m_LeftMouseDown;
    }

    public boolean isRightMouseDown() {
        return this.m_RightMouseDown;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.m_Owner != null) {
            this.m_Owner.getManager().draw((Graphics2D)g);
        }
    }
}

