/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.segmentation;

import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.LinkedList;

public class ImageUtils {
    public static void combineImages(BufferedImage source, BufferedImage target) {
        if (source.getWidth() != target.getWidth()) {
            throw new IllegalArgumentException("Images differ in width: " + source.getWidth() + " != " + target.getWidth());
        }
        if (source.getHeight() != target.getHeight()) {
            throw new IllegalArgumentException("Images differ in height: " + source.getHeight() + " != " + target.getHeight());
        }
        int[] pixSource = source.getRGB(0, 0, source.getWidth(), source.getHeight(), null, 0, source.getWidth());
        int[] pixTarget = target.getRGB(0, 0, target.getWidth(), target.getHeight(), null, 0, target.getWidth());
        int black = Color.BLACK.getRGB();
        boolean modified = false;
        for (int i = 0; i < pixSource.length; ++i) {
            if (pixSource[i] == black || pixSource[i] == pixTarget[i]) continue;
            pixTarget[i] = pixSource[i];
            modified = true;
        }
        if (modified) {
            target.setRGB(0, 0, target.getWidth(), target.getHeight(), pixTarget, 0, target.getWidth());
        }
    }

    public static void replaceColor(BufferedImage image, Color oldColor, Color newColor) {
        int oldC = oldColor.getRGB();
        int newC = newColor.getRGB();
        int[] pixels = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
        boolean modified = false;
        for (int i = 0; i < pixels.length; ++i) {
            if (pixels[i] != oldC) continue;
            pixels[i] = newC;
            modified = true;
        }
        if (modified) {
            image.setRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
        }
    }

    public static void initImage(BufferedImage image, Color color) {
        int black = Color.BLACK.getRGB();
        int rgb = color.getRGB();
        int[] pixels = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
        boolean modified = false;
        for (int i = 0; i < pixels.length; ++i) {
            if (pixels[i] == black) continue;
            pixels[i] = rgb;
            modified = true;
        }
        if (modified) {
            image.setRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
        }
    }

    public static BufferedImage newImage(int width, int height) {
        int black = Color.BLACK.getRGB();
        int[] pixels = new int[width * height];
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = black;
        }
        BufferedImage result = new BufferedImage(width, height, 2);
        result.setRGB(0, 0, result.getWidth(), result.getHeight(), pixels, 0, result.getWidth());
        return result;
    }

    protected static boolean requiresReplacement(int pixel, Integer target, int replacement) {
        if (target == null) {
            return pixel != replacement;
        }
        return pixel == target;
    }

    public static void fill(BufferedImage image, Point n, Color targetColor, Color replacementColor) {
        Integer target = targetColor == null ? null : Integer.valueOf(targetColor.getRGB());
        int replacement = replacementColor.getRGB();
        if (target != null && target == replacement) {
            return;
        }
        int x = (int)n.getX();
        int y = (int)n.getY();
        if (target != null && image.getRGB(x, y) != target.intValue()) {
            return;
        }
        image.setRGB(x, y, replacement);
        int w = image.getWidth();
        int h = image.getHeight();
        LinkedList<Point> queue = new LinkedList<Point>();
        queue.add(n);
        while (!queue.isEmpty()) {
            n = (Point)queue.removeFirst();
            x = (int)n.getX();
            y = (int)n.getY();
            if (x > 0 && ImageUtils.requiresReplacement(image.getRGB(x - 1, y), target, replacement)) {
                image.setRGB(x - 1, y, replacement);
                queue.add(new Point(x - 1, y));
            }
            if (x < w - 1 && ImageUtils.requiresReplacement(image.getRGB(x + 1, y), target, replacement)) {
                image.setRGB(x + 1, y, replacement);
                queue.add(new Point(x + 1, y));
            }
            if (y > 0 && ImageUtils.requiresReplacement(image.getRGB(x, y - 1), target, replacement)) {
                image.setRGB(x, y - 1, replacement);
                queue.add(new Point(x, y - 1));
            }
            if (y >= h - 1 || !ImageUtils.requiresReplacement(image.getRGB(x, y + 1), target, replacement)) continue;
            image.setRGB(x, y + 1, replacement);
            queue.add(new Point(x, y + 1));
        }
    }
}

